/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.generation.menu;

import com.ibm.pdp.explorer.associate.IPTAssociation;
import com.ibm.pdp.explorer.model.service.PTModelService;
import com.ibm.pdp.explorer.nature.PTNature;
import com.ibm.pdp.explorer.view.service.PTViewService;
import com.ibm.pdp.framework.GenResult;
import com.ibm.pdp.framework.GenerationManager;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.ResourceReference;
import com.ibm.pdp.framework.interfaces.IGenResult;
import com.ibm.pdp.framework.interfaces.IGenStatus;
import com.ibm.pdp.framework.interfaces.IGeneratedElement;
import com.ibm.pdp.framework.interfaces.IGenerationContext;
import com.ibm.pdp.framework.interfaces.IPattern;
import com.ibm.pdp.framework.interfaces.IResourceReference;
import com.ibm.pdp.framework.interfaces.IStatusMessage;
import com.ibm.pdp.framework.pattern.PdpPatternManager;
import com.ibm.pdp.generation.menu.GResult;
import com.ibm.pdp.generation.menu.GenerationResultListDialog;
import com.ibm.pdp.generation.menu.GenerationResultMultipleTreeViewerDialog;
import com.ibm.pdp.generation.menu.GenerationResultNode;
import com.ibm.pdp.generation.menu.Messages;
import com.ibm.pdp.generation.menu.PatternGeneration;
import com.ibm.pdp.generation.menu.SynchronizationTool;
import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.mdl.meta.Reference;
import com.ibm.pdp.references.ReferencesPlugin;
import com.ibm.pdp.references.associate.DesignGeneratedAssocManager;
import com.ibm.pdp.references.associate.DesignGeneratedAssociation;
import com.ibm.pdp.resources.PdpResourcesMgr;
import com.ibm.pdp.trace.PTTraceManager;
import com.ibm.pdp.util.Util;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.IProgressService;

public class PatternGenerationAction
extends Action {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String _patternName;
    private PatternGeneration _generateImplementor = null;
    private List<Document> _filesCurrentlySelected;
    private boolean _previewPossible = false;
    private IPTAssociation _associationToSelect = null;

    private static void checkDesynchronizationBetweenDesignsAndGenerateds(GResult gResult) {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {}
        for (IGenResult genResult : gResult.getGenResultList()) {
            if (genResult.getGenStatus() == null || genResult.getGenStatus().getState() != 0) continue;
            PatternGenerationAction.checkDesynchronizationBetweenDesignsAndGenerateds(genResult);
        }
    }

    PatternGenerationAction(String itemMenuName, String patternName, PatternGeneration generateImplementor) {
        this(itemMenuName, patternName, generateImplementor, false);
    }

    PatternGenerationAction(String itemMenuName, String patternName, PatternGeneration generateImplementor, boolean preview) {
        this._patternName = patternName;
        this._generateImplementor = generateImplementor;
        this._previewPossible = preview;
        this.setText(itemMenuName);
        this.setToolTipText(this.getText());
    }

    /*
     * Unable to fully structure code
     */
    private static void checkDesynchronizationBetweenDesignsAndGenerateds(IGenResult genResult) {
        generatedFiles = genResult.getGeneratedElements();
        if (generatedFiles != null) ** GOTO lbl10
        return;
lbl-1000:
        // 1 sources

        {
            generatedElement = (IGeneratedElement)generatedFiles.next();
            aGenProd = generatedElement.getGenerarationOutput();
            logicalSourceFileName = aGenProd.getResource();
            physicalSourceFileName = GenerationManager.getFullPathFromLogicalGeneratedPath((String)logicalSourceFileName);
            SynchronizationTool.checkIfTheGeneratedResourceNeedsRegeneration(logicalSourceFileName, physicalSourceFileName);
lbl10:
            // 2 sources

            ** while (generatedFiles.hasNext())
        }
lbl11:
        // 1 sources

    }

    /*
     * Loose catch block
     */
    public void run() {
        block14: {
            try {
                DesignGeneratedAssocManager.getInstance().removeResourcesChangedListener();
                GResult gResult = null;
                this._filesCurrentlySelected = this._generateImplementor.getSelectedDocuments();
                int max = this._filesCurrentlySelected.size();
                Shell parentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                if (max <= 1) {
                    gResult = PatternGenerationAction.generate(this._filesCurrentlySelected, this._patternName, parentShell, null, this._previewPossible);
                    PatternGenerationAction.checkDesynchronizationBetweenDesignsAndGenerateds(gResult);
                } else {
                    RunnableWithProgress genProcess = new RunnableWithProgress(this._filesCurrentlySelected, this._patternName, parentShell, this._previewPossible);
                    try {
                        if (PlatformUI.isWorkbenchRunning()) {
                            IProgressService ips = PlatformUI.getWorkbench().getProgressService();
                            ips.run(true, true, (IRunnableWithProgress)genProcess);
                            gResult = genProcess.getGResult();
                        } else {
                            genProcess.run((IProgressMonitor)new NullProgressMonitor());
                            gResult = genProcess.getGResult();
                        }
                    }
                    catch (InvocationTargetException e) {
                        Util.rethrow((Throwable)e.getCause());
                        DesignGeneratedAssocManager.getInstance().addResourcesChangedListener();
                        return;
                    }
                    catch (InterruptedException f) {
                        Util.rethrow((Throwable)f);
                        DesignGeneratedAssocManager.getInstance().addResourcesChangedListener();
                        return;
                    }
                }
                if (max <= 1) {
                    this.processSingleGenerationResults(gResult, parentShell);
                } else {
                    this.processMultipleGenerationsResults(gResult, parentShell);
                }
                break block14;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                DesignGeneratedAssocManager.getInstance().addResourcesChangedListener();
            }
        }
    }

    private void processSingleGenerationResults(GResult gResult, Shell parentShell) {
        Iterator iter;
        boolean moreThanOneElementGenerated;
        List<IGenResult> genResultList = gResult.getGenResultList();
        IGenResult genResult = genResultList.get(0);
        if (genResult.getGenStatus().getState() != 0) {
            StringBuilder sb = new StringBuilder();
            Iterator messages = genResult.getGenStatus().getMessages();
            while (messages.hasNext()) {
                IStatusMessage statusMessage = (IStatusMessage)messages.next();
                sb.append(statusMessage.getText());
                sb.append("\r\n");
            }
            String message = sb.toString();
            String title = Messages.PacGeneratorLabels_GENERATION_PROCESS;
            if (genResult.getGenStatus().getState() == 2) {
                MessageDialog.openWarning((Shell)parentShell, (String)title, (String)message);
            } else {
                PdpTool.logErr((Plugin)ReferencesPlugin.getDefault(), (String)"com.ibm.pdp.references", (String)message);
                MessageDialog.openError((Shell)parentShell, (String)title, (String)message);
                PdpTool.openErrorLog();
            }
            return;
        }
        boolean bl = moreThanOneElementGenerated = genResult.getCascadedGenerationOutput() != null && genResult.getCascadedGenerationOutput().hasNext();
        if (!moreThanOneElementGenerated && (iter = genResult.getGeneratedElements()) != null && iter.hasNext()) {
            iter.next();
            moreThanOneElementGenerated = iter.hasNext();
        }
        if (moreThanOneElementGenerated) {
            GenerationResultListDialog genResultListDialog = new GenerationResultListDialog(parentShell, genResult);
            genResultListDialog.open();
            List<Object> genObjectToOpen = genResultListDialog.getGeneratedObjectsToOpen();
            if (genObjectToOpen != null && genObjectToOpen.size() != 0) {
                this.openSelectedEditors(genObjectToOpen);
            }
        }
        String designIdToSelect = this._filesCurrentlySelected.get(0).getId();
        this.createAssociationForEntryPoint(designIdToSelect, gResult);
    }

    private void processMultipleGenerationsResults(GResult gResult, Shell parentShell) {
        List<IGenResult> results = gResult.getGenResultList();
        ArrayList<GenerationResultNode> nodes = new ArrayList<GenerationResultNode>();
        for (IGenResult genResult : results) {
            String physicalName;
            String logicalName;
            IResourceReference resourceReference;
            String resource = genResult.getEntryPoint().getResource();
            GenerationResultNode objectToGeneratedNode = new GenerationResultNode(resource, 0, null);
            nodes.add(objectToGeneratedNode);
            if (genResult.getGenStatus().getState() == 1) {
                StringBuilder sb = new StringBuilder();
                Iterator messages = genResult.getGenStatus().getMessages();
                while (messages.hasNext()) {
                    if (sb.length() != 0) {
                        sb.append("\r\n");
                    }
                    IStatusMessage statusMessage = (IStatusMessage)messages.next();
                    sb.append(statusMessage.getText());
                }
                String message = sb.toString();
                new GenerationResultNode(message, 3, objectToGeneratedNode);
                continue;
            }
            Iterator generatedElementIter = genResult.getGeneratedElements();
            while (generatedElementIter.hasNext()) {
                IGeneratedElement generatedElement = (IGeneratedElement)generatedElementIter.next();
                resourceReference = generatedElement.getGenerarationOutput();
                logicalName = resourceReference.getResource();
                physicalName = GenerationManager.getFullPathFromLogicalGeneratedPath((String)logicalName);
                new GenerationResultNode(physicalName, 1, objectToGeneratedNode);
            }
            Iterator genOutputIter = genResult.getCascadedGenerationOutput();
            while (genOutputIter != null && genOutputIter.hasNext()) {
                resourceReference = (IResourceReference)genOutputIter.next();
                logicalName = resourceReference.getResource();
                physicalName = GenerationManager.getFullPathFromLogicalGeneratedPath((String)logicalName);
                new GenerationResultNode(physicalName, 2, objectToGeneratedNode);
            }
        }
        GenerationResultMultipleTreeViewerDialog grmtd = new GenerationResultMultipleTreeViewerDialog(parentShell, nodes);
        int code = grmtd.open();
        if (code == 0) {
            List<Object> genObjectToOpen = grmtd.getGeneratedObjectsToOpen();
            if (genObjectToOpen != null && genObjectToOpen.size() != 0) {
                this.openSelectedEditors(genObjectToOpen);
            }
            String designIdToSelect = this._filesCurrentlySelected.get(0).getId();
            this.createAssociationForEntryPoint(designIdToSelect, gResult);
        }
    }

    private void createAssociationForEntryPoint(String designId, GResult gResult) {
        IFile cobol = PdpTool.getFile((String)gResult.getMainURI());
        if (cobol.exists()) {
            Document doc = PatternGenerationAction.getDocumentFromDesignId(designId, gResult.getMainURI());
            this._associationToSelect = new DesignGeneratedAssociation(cobol, doc, designId);
            this.fireEventToRefreshAssociations();
        }
    }

    private void fireEventToRefreshAssociations() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (PatternGenerationAction.this._associationToSelect != null) {
                    PTViewService.setSelection((ISelection)new StructuredSelection((Object)PatternGenerationAction.this._associationToSelect));
                    PatternGenerationAction.this._associationToSelect = null;
                }
            }
        });
    }

    private void openSelectedEditors(List<Object> genObjectToOpen) {
        for (Object object : genObjectToOpen) {
            if (!(object instanceof String)) continue;
            String toOpen = (String)object;
            Path p = new Path(toOpen);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)p);
            if (!file.exists()) continue;
            IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
            IWorkbenchPage currentPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                currentPage.openEditor((IEditorInput)new FileEditorInput(file), desc.getId());
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    public static GResult generate(List<Document> filesCurrentlySelected, String patternName, Shell parent, IProgressMonitor monitor, boolean preview) {
        int max = filesCurrentlySelected.size();
        ArrayList<IGenResult> genResultList = new ArrayList<IGenResult>();
        IPath mainPath = null;
        String mainLocation = null;
        String mainURI = null;
        if (monitor != null) {
            monitor.beginTask("", max * 100);
        }
        if (max > 1) {
            preview = false;
        }
        int i = 0;
        while (i < max) {
            Iterator references;
            List l;
            PTTraceManager traceManager;
            int frameworkTraceLevel;
            PTNature nature;
            if (monitor != null && monitor.isCanceled()) {
                return new GResult(genResultList, mainPath, mainLocation, mainURI);
            }
            Document metaDocument = filesCurrentlySelected.get(i);
            IPath path = PTModelService.getPath((String)metaDocument.getId());
            if (mainPath == null) {
                mainPath = path;
            }
            if (mainLocation == null && (nature = PTNature.getNature((String)metaDocument.getProject())) != null) {
                mainLocation = nature.getLocation();
            }
            if ((frameworkTraceLevel = (traceManager = PTTraceManager.getInstance()).getTraceLevel("com.ibm.pdp.framework")) > 0) {
                String message = "File to generate : " + path.toString();
                traceManager.trace(PatternGenerationAction.class, "com.ibm.pdp.framework", 1, message);
            }
            if (monitor != null) {
                monitor.setTaskName("Generate : " + metaDocument.getName());
                monitor.worked(100);
            }
            GenerateAndPreviewGenerationOptions context = null;
            if (preview && (l = PdpTool.getControllersFromDesignPath((String)metaDocument.getId(), (IPattern)PdpPatternManager.getPdpPattern((String)patternName))) != null && !l.isEmpty()) {
                context = new GenerateAndPreviewGenerationOptions();
                context.getGenerationProperties().put("CONTROLLER_FOR_PREVIEW", l);
            }
            IGenResult genResult = GenerationManager.generate((String)path.toString(), (String)patternName, (IProgressMonitor)monitor, context);
            if (mainURI == null && (references = genResult.getGeneratedElements()) != null && references.hasNext()) {
                IGeneratedElement generatedElement = (IGeneratedElement)references.next();
                IResourceReference ref = generatedElement.getGenerarationOutput();
                mainURI = GenerationManager.getFullPathFromLogicalGeneratedPath((String)ref.getResource());
            }
            if (genResult.getGenStatus().getState() == 1) {
                String generatorEntryPoint = path.toString();
                ResourceReference entryPoint = new ResourceReference(generatorEntryPoint, "");
                GenResult genResult2 = new GenResult(genResult.getGenStatus(), genResult.getPatternName(), (IResourceReference)entryPoint, null, null);
                genResultList.add((IGenResult)genResult2);
            } else {
                genResultList.add(genResult);
            }
            IGenStatus status = genResult.getGenStatus();
            if (frameworkTraceLevel > 0) {
                String message = null;
                message = status == null ? "==> File NOT generated" : (status.getState() == 1 ? "==> File NOT generated" : "==> File generated");
                traceManager.trace(PatternGenerationAction.class, "com.ibm.pdp.framework", 1, message);
            }
            ++i;
        }
        return new GResult(genResultList, mainPath, mainLocation, mainURI);
    }

    private static Document getDocumentFromDesignId(String designId, String fileName) {
        Iterator superRefs = PdpResourcesMgr.getInstance().getSuperReferences(designId);
        while (superRefs.hasNext()) {
            Reference ref = (Reference)superRefs.next();
            Document doc = PdpResourcesMgr.getInstance().getResource(ref.getSourceId());
            String suffix = String.valueOf(doc.getName()) + "." + doc.getType();
            if (!fileName.endsWith(suffix)) continue;
            return doc;
        }
        return null;
    }

    private static class GenerateAndPreviewGenerationOptions
    implements IGenerationContext {
        Map<String, Object> properties = new HashMap<String, Object>();

        public Map<String, Object> getGenerationProperties() {
            return this.properties;
        }

        public GenerateAndPreviewGenerationOptions() {
            this.initializeProperties();
        }

        private void initializeProperties() {
            this.properties.put("GENERATE_AND_COMPARE", "true");
        }
    }

    private static class RunnableWithProgress
    implements IRunnableWithProgress {
        private GResult _result;
        List<Document> _filesCurrentlySelected;
        private String _patternName;
        private Shell _parent;
        private boolean _preview;

        public RunnableWithProgress(List<Document> filesCurrentlySelected, String patternName, Shell parent, boolean preview) {
            this._filesCurrentlySelected = filesCurrentlySelected;
            this._patternName = patternName;
            this._parent = parent;
            this._preview = preview;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            this._result = PatternGenerationAction.generate(this._filesCurrentlySelected, this._patternName, this._parent, monitor, this._preview);
            PatternGenerationAction.checkDesynchronizationBetweenDesignsAndGenerateds(this._result);
        }

        public GResult getGResult() {
            return this._result;
        }
    }
}

