/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.generation.menu;

import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.explorer.model.service.PTModelService;
import com.ibm.pdp.explorer.plugin.IPTGenerate;
import com.ibm.pdp.framework.GenerationManager;
import com.ibm.pdp.framework.interfaces.IPattern;
import com.ibm.pdp.framework.interfaces.internal.IPacPattern;
import com.ibm.pdp.generation.menu.Messages;
import com.ibm.pdp.generation.menu.PatternGenerationAction;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.meta.Document;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;

public class PatternGeneration
implements IPTGenerate {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private List<Document> _selectedDocuments;

    public List<Action> getGenerateWizardActions(List<Document> metaDocuments) {
        this._selectedDocuments = new ArrayList<Document>();
        HashSet<String> selectedPaths = new HashSet<String>();
        for (Document metaDocument : metaDocuments) {
            this._selectedDocuments.add(metaDocument);
            IPath path = PTModelService.getPath((String)metaDocument.getId());
            selectedPaths.add(path.toOSString());
        }
        if (this._selectedDocuments.size() < 1) {
            return null;
        }
        String[] allPaths = new String[selectedPaths.size()];
        selectedPaths.toArray(allPaths);
        List patterns = GenerationManager.getCommonGeneratorsFor((String[])allPaths);
        if (patterns != null && patterns.size() > 0) {
            RadicalEntity re = PTEditorService.getSharedResource((IPath)new Path(allPaths[0]));
            String designpath = re.getDesignId(re.getProject());
            ArrayList<Action> actions = new ArrayList<Action>();
            for (IPattern pattern : patterns) {
                PatternGenerationAction action = new PatternGenerationAction(pattern.getGenerationMenuName(), pattern.getName(), this);
                actions.add(action);
                if (allPaths.length != 1 || !(pattern instanceof IPacPattern) || !((IPacPattern)pattern).isPreviewPossible(designpath)) continue;
                action = new PatternGenerationAction(String.valueOf(pattern.getGenerationMenuName()) + " - " + Messages.GenerationPreview, pattern.getName(), this, true);
                actions.add(action);
            }
            return actions;
        }
        return null;
    }

    public List<Document> getSelectedDocuments() {
        return this._selectedDocuments;
    }
}

