/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.generation.menu;

import com.ibm.pdp.generation.menu.GenerationResultNode;
import com.ibm.pdp.generation.menu.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class GenerationResultMultipleTreeViewerDialog
extends Dialog {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private CheckboxTreeViewer viewer;
    protected ArrayList<GenerationResultNode> nodes;
    Object[] objects = null;

    protected GenerationResultMultipleTreeViewerDialog(Shell parentShell, ArrayList<GenerationResultNode> nodes) {
        super(parentShell);
        this.nodes = nodes;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.initializeDialogUnits((Control)composite);
        GridData textGD = new GridData(768);
        textGD.grabExcessHorizontalSpace = true;
        Label _filterLabel = new Label(composite, 0);
        _filterLabel.setText(Messages.GenerationResultListDialog_Following_files);
        Label _filterLabel2 = new Label(composite, 0);
        _filterLabel2.setText(Messages.GenerationResultListDialog_Select_a_file);
        this.viewer = new CheckboxTreeViewer(composite);
        this.initializeTree();
        GridData data = new GridData(1808);
        data.minimumHeight = 50;
        data.minimumWidth = 50;
        data.heightHint = 300;
        data.widthHint = 500;
        this.viewer.getTree().setLayoutData((Object)data);
        this.addSelectionButtons(composite);
        Dialog.applyDialogFont((Control)composite);
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                GenerationResultMultipleTreeViewerDialog.this.objects = GenerationResultMultipleTreeViewerDialog.this.viewer.getCheckedElements();
            }
        });
        return composite;
    }

    private void addSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(0x1000008, 128, true, false));
        Button selectButton = this.createButton(buttonComposite, 18, Messages.GenerationResultListDialog_Select_all, false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerationResultMultipleTreeViewerDialog.this.checkAll();
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        Button deselectButton = this.createButton(buttonComposite, 19, Messages.GenerationResultListDialog_Deselect_all, false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerationResultMultipleTreeViewerDialog.this.uncheckAll();
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
    }

    private void initializeTree() {
        this.viewer.setCheckStateProvider((ICheckStateProvider)new CheckStateProvider());
        GenerationResultNodeContentProvider provider = new GenerationResultNodeContentProvider();
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object obj = event.getElement();
                GenerationResultNode node = (GenerationResultNode)obj;
                if (node.getParent() == null) {
                    GenerationResultMultipleTreeViewerDialog.this.viewer.setChecked((Object)node, false);
                }
            }
        });
        this.viewer.setAutoExpandLevel(2);
        this.viewer.setContentProvider((IContentProvider)provider);
        this.viewer.setLabelProvider((IBaseLabelProvider)provider);
        this.viewer.setUseHashlookup(true);
        this.viewer.setInput(this.nodes);
    }

    List<Object> getGeneratedObjectsToOpen() {
        ArrayList<Object> list = new ArrayList<Object>();
        Object[] objectArray = this.objects;
        int n = this.objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            list.add(((GenerationResultNode)object).getName());
            ++n2;
        }
        return list;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.GenerationResultListDialog_Generation_results);
    }

    public void create() {
        this.setShellStyle(67696);
        super.create();
    }

    private void checkAll() {
        for (GenerationResultNode node : this.nodes) {
            for (GenerationResultNode child : node.getChildren()) {
                this.viewer.setChecked((Object)child, true);
            }
        }
    }

    private void uncheckAll() {
        for (GenerationResultNode node : this.nodes) {
            for (GenerationResultNode child : node.getChildren()) {
                this.viewer.setChecked((Object)child, false);
            }
        }
    }

    private static class CheckStateProvider
    implements ICheckStateProvider {
        private CheckStateProvider() {
        }

        public boolean isChecked(Object element) {
            return false;
        }

        public boolean isGrayed(Object element) {
            return ((GenerationResultNode)element).getParent() == null;
        }
    }

    private static class GenerationResultNodeContentProvider
    extends LabelProvider
    implements ITreeContentProvider {
        private GenerationResultNodeContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ArrayList) {
                return ((ArrayList)parentElement).toArray();
            }
            if (((GenerationResultNode)parentElement).getChildren() != null) {
                return ((GenerationResultNode)parentElement).getChildren().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return ((GenerationResultNode)element).getName();
        }

        public void dispose() {
            super.dispose();
        }
    }
}

