/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.generation.menu;

import com.ibm.pdp.framework.GenResult;
import com.ibm.pdp.framework.GenerationManager;
import com.ibm.pdp.framework.interfaces.IGenResult;
import com.ibm.pdp.framework.interfaces.IGeneratedElement;
import com.ibm.pdp.framework.interfaces.IResourceReference;
import com.ibm.pdp.generation.menu.Messages;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class GenerationResultListDialog
extends Dialog {
    protected Object _inputElement;
    protected ILabelProvider _labelProvider;
    protected IStructuredContentProvider _contentProvider;
    protected List<Object> generatedObjectsToOpen;
    protected CheckboxTableViewer _listViewer;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2011, 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public GenerationResultListDialog(Shell shell, IGenResult input) {
        super(shell);
        this._inputElement = input;
    }

    private void addSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(0x1000008, 128, true, false));
        Button selectButton = this.createButton(buttonComposite, 18, Messages.GenerationResultListDialog_Select_all, false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerationResultListDialog.this._listViewer.setAllChecked(true);
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        Button deselectButton = this.createButton(buttonComposite, 19, Messages.GenerationResultListDialog_Deselect_all, false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerationResultListDialog.this._listViewer.setAllChecked(false);
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
    }

    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        this.initializeViewer();
        return composite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.GenerationResultListDialog_Generation_results);
    }

    public void create() {
        this.setShellStyle(67696);
        super.create();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.initializeDialogUnits((Control)composite);
        GridData textGD = new GridData(768);
        textGD.grabExcessHorizontalSpace = true;
        Label _filterLabel = new Label(composite, 0);
        _filterLabel.setText(Messages.GenerationResultListDialog_Following_files);
        Label _filterLabel2 = new Label(composite, 0);
        _filterLabel2.setText(Messages.GenerationResultListDialog_Select_a_file);
        this._listViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)67588);
        GridData data = new GridData(1808);
        data.minimumHeight = 50;
        data.minimumWidth = 50;
        data.heightHint = 100;
        data.widthHint = 500;
        this._listViewer.getTable().setLayoutData((Object)data);
        this._labelProvider = new ILabelProvider(){

            public void removeListener(ILabelProviderListener arg0) {
            }

            public boolean isLabelProperty(Object arg0, String arg1) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener arg0) {
            }

            public String getText(Object arg0) {
                return arg0.toString();
            }

            public Image getImage(Object arg0) {
                return null;
            }
        };
        this._listViewer.setLabelProvider((IBaseLabelProvider)this._labelProvider);
        this._contentProvider = new GenResulContentProvider();
        this._listViewer.setContentProvider((IContentProvider)this._contentProvider);
        this.addSelectionButtons(composite);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected CheckboxTableViewer getViewer() {
        return this._listViewer;
    }

    private void initializeViewer() {
        this._listViewer.setInput(this._inputElement);
        this._listViewer.getTable().pack();
    }

    protected void okPressed() {
        Object[] children = this._contentProvider.getElements(this._inputElement);
        if (children != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            int i = 0;
            while (i < children.length) {
                Object element = children[i];
                if (this._listViewer.getChecked(element)) {
                    list.add(element);
                }
                ++i;
            }
            this.generatedObjectsToOpen = list;
        }
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    public List<Object> getGeneratedObjectsToOpen() {
        return this.generatedObjectsToOpen;
    }

    public class GenResulContentProvider
    implements IStructuredContentProvider {
        private GenResult _genResult;
        private String[] results = new String[0];

        public void dispose() {
            this._genResult = null;
        }

        public void inputChanged(Viewer viewer, Object arg1, Object arg2) {
            if (arg2 instanceof GenResult) {
                String physicalSourceFileName;
                String logicalSourceFileName;
                IResourceReference rr;
                ArrayList<String> generationOutpouts = new ArrayList<String>();
                this._genResult = (GenResult)arg2;
                Iterator iter = this._genResult.getGeneratedElements();
                while (iter.hasNext()) {
                    IGeneratedElement generatedElement = (IGeneratedElement)iter.next();
                    rr = generatedElement.getGenerarationOutput();
                    logicalSourceFileName = rr.getResource();
                    physicalSourceFileName = GenerationManager.getFullPathFromLogicalGeneratedPath((String)logicalSourceFileName);
                    generationOutpouts.add(physicalSourceFileName);
                }
                Iterator iter2 = this._genResult.getCascadedGenerationOutput();
                while (iter2 != null && iter2.hasNext()) {
                    rr = (IResourceReference)iter2.next();
                    logicalSourceFileName = rr.getResource();
                    physicalSourceFileName = GenerationManager.getFullPathFromLogicalGeneratedPath((String)logicalSourceFileName);
                    generationOutpouts.add(physicalSourceFileName);
                }
                this.results = generationOutpouts.toArray(this.results);
            }
        }

        public Object[] getElements(Object arg0) {
            return this.results;
        }
    }
}

