/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.generation.manager.view;

import com.ibm.pdp.explorer.plugin.PTExplorerPlugin;
import com.ibm.pdp.explorer.view.IPTSerializableView;
import com.ibm.pdp.explorer.view.tool.PTAttributeItem;
import com.ibm.pdp.explorer.view.tool.PTSerializerConfiguration;
import com.ibm.pdp.explorer.wizard.PTExportQueryWizard;
import com.ibm.pdp.generation.manager.GenerationCacheController;
import com.ibm.pdp.generation.manager.view.ColumnSortActionGroup;
import com.ibm.pdp.generation.manager.view.DisplayShortLabelActionGroup;
import com.ibm.pdp.generation.manager.view.FilterActionGroup;
import com.ibm.pdp.generation.manager.view.GenerateAction;
import com.ibm.pdp.generation.manager.view.GenerationCacheDataLabelProvider;
import com.ibm.pdp.generation.manager.view.GenerationCacheRefreshAction;
import com.ibm.pdp.generation.manager.view.GenerationManagerContentProvider;
import com.ibm.pdp.generation.manager.view.Messages;
import com.ibm.pdp.generation.manager.view.OpenCobolAction;
import com.ibm.pdp.generation.manager.view.OpenDesignAction;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.ViewPart;

public class GenerationManagerView
extends ViewPart
implements IPTSerializableView {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2022.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String HELP_PLUGIN = "com.ibm.pdp.doc.cshelp";
    public static final String HEADER_KEY0 = "Design";
    public static final String HEADER_KEY1 = "Cobol";
    public static final String HEADER_KEY2 = "Pattern";
    public static final String HEADER_KEY3 = "DephasedDesign";
    public static final String HEADER_KEY5 = "ToRegenerate";
    public static final String HEADER_KEY6 = "ErrorInDesign";
    private TreeViewer viewer;
    public static final String _VIEW_ID = String.valueOf(GenerationManagerView.class.getName()) + "_ID";
    private GenerationCacheRefreshAction refreshAction;
    protected Troolean refreshActionAlreadyDefined = Troolean.UNINITIALIZED;
    private OpenDesignAction openDesignAction;
    private OpenCobolAction openCobolAction;
    private GenerateAction generateAction;
    private TreeColumn columnDesign;
    private TreeColumn columnGenerated;
    private TreeColumn columnPattern;
    private TreeColumn columnDephased;
    private TreeColumn columnToRegenerate;
    private TreeColumn columnError;
    private GenerationCacheDataLabelProvider gcdLabelProvider;
    private int[] tableColumnDirections = new int[]{1, 1, 1, 1, 1, 1};
    boolean[] tableColumnShortLabels = new boolean[6];
    boolean[] tableColumnFilter = new boolean[]{true, true, true, true, true, true};
    private ColumnSortActionGroup _sortActionGroup;
    private DisplayShortLabelActionGroup _shortLabelActionGroup;
    private FilterActionGroup _filterActionGroup;
    private ExportGenerationManagerAction _exportQueryAction;
    private MyFilteredTree filteredTree;
    public static final int ASC = 1;
    public static final int NONE = 0;
    public static final int DESC = -1;

    public void createPartControl(Composite parent) {
        this.refreshAction = new GenerationCacheRefreshAction(this);
        class MyFilter
        extends PatternFilter {
            private Pattern stringMatcher;

            MyFilter() {
            }

            protected boolean isLeafMatch(Viewer viewer, Object element) {
                TreeViewer treeViewer = (TreeViewer)viewer;
                int numberOfColumns = treeViewer.getTree().getColumnCount();
                boolean isMatching = false;
                int columnIndex = 0;
                while (columnIndex < numberOfColumns) {
                    boolean columnPresent = GenerationManagerView.this.tableColumnFilter[columnIndex];
                    if (columnPresent) {
                        String labelText = null;
                        labelText = columnIndex == 3 ? GenerationManagerView.this.gcdLabelProvider.getModifiedDesign(element, " ", GenerationManagerView.this.tableColumnShortLabels[3], false) : GenerationManagerView.this.gcdLabelProvider.getColumnText(element, columnIndex);
                        isMatching |= this.wordMatches2(labelText);
                    }
                    ++columnIndex;
                }
                return isMatching;
            }

            public void setPattern(String patternString) {
                super.setPattern(patternString);
                if (patternString == null || patternString.equals("")) {
                    this.stringMatcher = null;
                } else {
                    String patternModified = ".*" + patternString + ".*";
                    this.stringMatcher = Pattern.compile(patternModified, 2);
                }
            }

            private boolean match(String string) {
                if (this.stringMatcher == null) {
                    return true;
                }
                Matcher m = this.stringMatcher.matcher(string);
                return m.matches();
            }

            protected boolean wordMatches2(String text) {
                if (text == null) {
                    return false;
                }
                if (this.match(text)) {
                    return true;
                }
                String[] words = this.getWords(text);
                int i = 0;
                while (i < words.length) {
                    String word = words[i];
                    if (this.match(word)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }

            private String[] getWords(String text) {
                String[] words2 = text.split("[^a-zA-Z_0-9\\.]");
                return words2;
            }
        }
        this.filteredTree = new MyFilteredTree(parent, 66306, new MyFilter(), true);
        this.viewer = this.filteredTree.getViewer();
        Tree tree = this.viewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        String[] headers = new String[]{Messages.GenerationManagerView_Header_design, Messages.GenerationManagerView_Header_generated_artifact, Messages.GenerationManagerView_Header_pattern, Messages.GenerationManagerView_header_dephased_design, Messages.GenerationManagerView_Header_to_regenerate, Messages.GenerationManagerView_Header_error};
        String[] headerKeys = new String[]{HEADER_KEY0, HEADER_KEY1, HEADER_KEY2, HEADER_KEY3, HEADER_KEY5, HEADER_KEY6};
        this.viewer.setUseHashlookup(true);
        this.viewer.setContentProvider((IContentProvider)new GenerationManagerContentProvider());
        this.gcdLabelProvider = new GenerationCacheDataLabelProvider(this);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.gcdLabelProvider);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                int size = selection.size();
                String message = size == 0 || size == 1 ? "" : String.valueOf(size) + Messages.GenerationManagerView_items_selected;
                GenerationManagerView.this.getViewSite().getActionBars().getStatusLineManager().setMessage(message);
            }
        });
        this.columnDesign = new TreeColumn(tree, 0);
        this.columnDesign.setText(headers[0]);
        this.columnDesign.setData((Object)headerKeys[0]);
        this.columnDesign.setMoveable(true);
        class MySelectionListener
        extends SelectionAdapter {
            private int _nature;
            private TreeColumn _column;

            MySelectionListener(TreeColumn column, int nature) {
                this._nature = nature;
                this._column = column;
            }

            public void widgetSelected(SelectionEvent arg0) {
                Tree tree = this._column.getParent();
                if (tree.getSortColumn() != this._column) {
                    tree.setSortColumn(this._column);
                    tree.setSortDirection(GenerationManagerView.this.tableColumnDirections[this._nature - 1] == 1 ? 128 : 1024);
                } else {
                    int newDirection;
                    int direction = GenerationManagerView.this.tableColumnDirections[this._nature - 1];
                    ((GenerationManagerView)GenerationManagerView.this).tableColumnDirections[this._nature - 1] = newDirection = direction * -1;
                    if (newDirection == 1) {
                        tree.setSortDirection(128);
                    } else {
                        tree.setSortDirection(1024);
                    }
                }
                GenerationManagerView.this.sort();
            }
        }
        this.columnDesign.addSelectionListener((SelectionListener)new MySelectionListener(this.columnDesign, 1));
        this.columnGenerated = new TreeColumn(tree, 0);
        this.columnGenerated.setText(headers[1]);
        this.columnGenerated.setData((Object)headerKeys[1]);
        this.columnGenerated.setMoveable(true);
        this.columnGenerated.addSelectionListener((SelectionListener)new MySelectionListener(this.columnGenerated, 2));
        this.columnPattern = new TreeColumn(tree, 0);
        this.columnPattern.setText(headers[2]);
        this.columnPattern.setData((Object)headerKeys[2]);
        this.columnPattern.setMoveable(true);
        this.columnPattern.addSelectionListener((SelectionListener)new MySelectionListener(this.columnPattern, 3));
        this.columnDephased = new TreeColumn(tree, 0);
        TreeViewerColumn dephasedTVC = new TreeViewerColumn(this.viewer, this.columnDephased);
        dephasedTVC.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object object) {
                return GenerationManagerView.this.gcdLabelProvider.getColumnText(object, 3);
            }

            public String getToolTipText(Object obj) {
                return GenerationManagerView.this.gcdLabelProvider.getModifiedDesign(obj, "\n", false, true);
            }
        });
        this.columnDephased.setText(headers[3]);
        this.columnDephased.setData((Object)headerKeys[3]);
        this.columnDephased.setMoveable(true);
        this.columnDephased.addSelectionListener((SelectionListener)new MySelectionListener(this.columnDephased, 4));
        this.columnToRegenerate = new TreeColumn(tree, 0);
        TreeViewerColumn toRegenerateTVC = new TreeViewerColumn(this.viewer, this.columnToRegenerate);
        toRegenerateTVC.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object object) {
                return GenerationManagerView.this.gcdLabelProvider.getColumnText(object, 4);
            }

            public String getToolTipText(Object obj) {
                return GenerationManagerView.this.gcdLabelProvider.getToRegenerateDetailText(obj, "\n", false, true);
            }
        });
        this.columnToRegenerate.setText(headers[4]);
        this.columnToRegenerate.setData((Object)headerKeys[4]);
        this.columnToRegenerate.setMoveable(true);
        this.columnToRegenerate.addSelectionListener((SelectionListener)new MySelectionListener(this.columnToRegenerate, 5));
        this.columnError = new TreeColumn(tree, 0);
        this.columnError.setText(headers[5]);
        this.columnError.setData((Object)headerKeys[5]);
        this.columnError.setMoveable(true);
        this.columnError.addSelectionListener((SelectionListener)new MySelectionListener(this.columnError, 6));
        this.viewer.setInput((Object)GenerationCacheController.getCache());
        TreeColumn[] treeColumnArray = tree.getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn tc = treeColumnArray[n2];
            tc.pack();
            ++n2;
        }
        this.viewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 0x100000E) {
                    GenerationManagerView.this.refreshAction.run();
                }
            }

            public void keyReleased(KeyEvent event) {
            }
        });
        this._exportQueryAction = new ExportGenerationManagerAction(this);
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        this.fillToolBarMenu(toolBarManager);
        int[] sortModes = new int[]{1, 2, 3, 4, 5, 6};
        this._sortActionGroup = new ColumnSortActionGroup(this, sortModes);
        this._shortLabelActionGroup = new DisplayShortLabelActionGroup(this);
        this._filterActionGroup = new FilterActionGroup(this);
        IMenuManager barMenuMgr = this.getViewSite().getActionBars().getMenuManager();
        barMenuMgr.setRemoveAllWhenShown(true);
        this.fillActionBarMenu(barMenuMgr);
        barMenuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                GenerationManagerView.this.fillActionBarMenu(menu);
            }
        });
        tree.setSortColumn(this.columnDesign);
        tree.setSortDirection(128);
        this._sortActionGroup.check(1, true);
        this.sort();
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                GenerationManagerView.this.fillContextMenu(menu);
            }
        });
        Menu contextMenu = menuMgr.createContextMenu((Control)tree);
        tree.setMenu(contextMenu);
        GenerationManagerView.setHelpMechanism(parent, "Generation_manager");
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
    }

    public void setFocus() {
    }

    private void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection == null || selection.size() <= 0) {
            return;
        }
        boolean singleSelection = selection.size() == 1;
        this.getOpenDesignAction().setEnabled(singleSelection);
        this.getOpenCobolAction().setEnabled(singleSelection);
        menu.add((IAction)this.getOpenDesignAction());
        menu.add((IAction)this.getOpenCobolAction());
        menu.add((IAction)this.getGenerateAction());
    }

    private boolean isRefreshActionAlreadyDefined() {
        if (this.refreshActionAlreadyDefined != Troolean.UNINITIALIZED) {
            return this.refreshActionAlreadyDefined != Troolean.FALSE;
        }
        this.refreshActionAlreadyDefined = Troolean.FALSE;
        IExtensionRegistry extRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extPoint = extRegistry.getExtensionPoint("org.eclipse.ui.viewActions");
        if (extPoint == null) {
            return false;
        }
        IExtension[] extensions = extPoint.getExtensions();
        int extensionsNb = extensions.length;
        int i = 0;
        while (i < extensionsNb) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int configElementsNb = configElements.length;
            int j = 0;
            while (j < configElementsNb) {
                IConfigurationElement configElement = configElements[j];
                String result = configElement.getAttribute("id");
                if ("com.ibm.teampdp.synchronization.viewContrib".equals(result)) {
                    this.refreshActionAlreadyDefined = Troolean.TRUE;
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private void fillToolBarMenu(IToolBarManager toolBarManager) {
        toolBarManager.add((IAction)this._exportQueryAction);
        if (this.isRefreshActionAlreadyDefined()) {
            return;
        }
        toolBarManager.add((IAction)this.refreshAction);
    }

    public void refresh(boolean resizeColumn) {
        this.viewer.refresh();
        if (resizeColumn) {
            Tree tree = this.viewer.getTree();
            TreeColumn[] treeColumnArray = tree.getColumns();
            int n = treeColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeColumn tc = treeColumnArray[n2];
                tc.pack();
                ++n2;
            }
        }
    }

    private Action getOpenDesignAction() {
        if (this.openDesignAction == null) {
            this.openDesignAction = new OpenDesignAction(this);
        }
        return this.openDesignAction;
    }

    private Action getOpenCobolAction() {
        if (this.openCobolAction == null) {
            this.openCobolAction = new OpenCobolAction(this);
        }
        return this.openCobolAction;
    }

    private Action getGenerateAction() {
        if (this.generateAction == null) {
            this.generateAction = new GenerateAction(this);
        }
        return this.generateAction;
    }

    IStructuredSelection getSelection() {
        return (IStructuredSelection)this.viewer.getSelection();
    }

    public void setSorter(int sorterID) {
        Tree tree = null;
        switch (sorterID) {
            case 1: {
                tree = this.columnDesign.getParent();
                tree.setSortColumn(this.columnDesign);
                break;
            }
            case 2: {
                tree = this.columnDesign.getParent();
                tree.setSortColumn(this.columnGenerated);
                break;
            }
            case 3: {
                tree = this.columnDesign.getParent();
                tree.setSortColumn(this.columnPattern);
                break;
            }
            case 4: {
                tree = this.columnDesign.getParent();
                tree.setSortColumn(this.columnDephased);
                break;
            }
            case 5: {
                tree = this.columnDesign.getParent();
                tree.setSortColumn(this.columnToRegenerate);
                break;
            }
            case 6: {
                tree = this.columnDesign.getParent();
                tree.setSortColumn(this.columnError);
            }
        }
        if (tree != null) {
            tree.setSortDirection(this.tableColumnDirections[sorterID - 1] == 1 ? 128 : 1024);
        }
        this.sort();
    }

    private void fillActionBarMenu(IMenuManager menu) {
        this._sortActionGroup.fillMenu(menu);
        this._shortLabelActionGroup.fillMenu(menu);
        this._filterActionGroup.fillMenu(menu);
    }

    public void changeDirection() {
        int newDirection;
        Tree tree = this.columnDesign.getParent();
        int sortID = this.getSortID(tree.getSortColumn());
        if (this.tableColumnDirections[sortID - 1] == 1) {
            tree.setSortDirection(1024);
        } else {
            tree.setSortDirection(128);
        }
        int direction = this.tableColumnDirections[sortID - 1];
        this.tableColumnDirections[sortID - 1] = newDirection = direction * -1;
        this.sort();
    }

    public void sort() {
        Tree tree = this.columnDesign.getParent();
        boolean ascending = true;
        if (tree.getSortDirection() == 1024) {
            ascending = false;
        }
        TreeColumn sortColumn = tree.getSortColumn();
        int columnId = this.getSortID(sortColumn);
        boolean shortLabel = this.tableColumnShortLabels[columnId - 1];
        GenerationCacheController.getCache().sort(columnId, ascending, shortLabel);
        this._sortActionGroup.check(columnId, tree.getSortDirection() == 128);
        this.refresh(false);
    }

    private int getSortID(TreeColumn column) {
        int columnId = 1;
        if (column == null) {
            return columnId;
        }
        if (column == this.columnGenerated) {
            columnId = 2;
        } else if (column == this.columnPattern) {
            columnId = 3;
        } else if (column == this.columnDephased) {
            columnId = 4;
        } else if (column == this.columnToRegenerate) {
            columnId = 5;
        } else if (column == this.columnError) {
            columnId = 6;
        }
        return columnId;
    }

    public void changeFilterFor(int column) {
        boolean bl = this.tableColumnFilter[column - 1] = !this.tableColumnFilter[column - 1];
        if (this.filteredTree != null) {
            this.filteredTree.textChanged();
        }
    }

    public void changeShortLabelFor(int column) {
        this.tableColumnShortLabels[column - 1] = !this.tableColumnShortLabels[column - 1];
        this.sort();
    }

    private static void setHelpMechanism(Composite parent, String contextId) {
        String aCtx = "com.ibm.pdp.doc.cshelp." + contextId;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, aCtx);
    }

    public PTSerializerConfiguration getSerializerConfiguration() {
        PTAttributeItem[] allAttributes = new PTAttributeItem[]{new PTAttributeItem(HEADER_KEY0, Messages.GenerationManagerView_Header_design), new PTAttributeItem(HEADER_KEY1, Messages.GenerationManagerView_Header_generated_artifact), new PTAttributeItem(HEADER_KEY2, Messages.GenerationManagerView_Header_pattern), new PTAttributeItem(HEADER_KEY3, Messages.GenerationManagerView_header_dephased_design), new PTAttributeItem(HEADER_KEY5, Messages.GenerationManagerView_Header_to_regenerate), new PTAttributeItem(HEADER_KEY6, Messages.GenerationManagerView_Header_error)};
        String[] defAttributeIds = new String[]{HEADER_KEY0, HEADER_KEY1, HEADER_KEY2, HEADER_KEY3, HEADER_KEY5, HEADER_KEY6};
        String[] titlesAndDescriptions = new String[]{Messages.GenerationManagerView_export_data, Messages.GenerationManagerView_export_data, Messages.GenerationManagerView_select_file, "Export Generation Manager data"};
        String prefKey = _VIEW_ID;
        return new PTSerializerConfiguration(allAttributes, defAttributeIds, prefKey, titlesAndDescriptions);
    }

    public void serialize(List<PTAttributeItem> preferredAttributes, String outputFile) {
        GenerationCacheController.getCache().serializeDatas(preferredAttributes, outputFile);
    }

    class ExportGenerationManagerAction
    extends Action {
        private IPTSerializableView _serializableView;

        public ExportGenerationManagerAction(IPTSerializableView serializableView) {
            this._serializableView = serializableView;
            this.setText(Messages.GenerationManagerView_export);
            this.setToolTipText(Messages.GenerationManagerView_export_data);
            this.setImageDescriptor(PTExplorerPlugin.getDefault().getImageDescriptor("export_query"));
        }

        public void run() {
            Shell shell = this._serializableView.getSite().getShell();
            shell.setCursor(new Cursor((Device)shell.getDisplay(), 1));
            PTExportQueryWizard wizard = new PTExportQueryWizard(this._serializableView);
            WizardDialog dialog = new WizardDialog(this._serializableView.getSite().getShell(), (IWizard)wizard);
            dialog.open();
            shell.setCursor(null);
        }
    }

    class MyFilteredTree
    extends FilteredTree {
        public MyFilteredTree(Composite parent, int treeStyle, PatternFilter filter, boolean useNewLook) {
            super(parent, treeStyle, filter, useNewLook);
        }

        public void textChanged() {
            super.textChanged();
        }
    }

    public static enum Troolean {
        UNINITIALIZED,
        FALSE,
        TRUE;

    }
}

