/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.generation.manager.view;

import com.ibm.pdp.generation.manager.GenerationCache;
import com.ibm.pdp.generation.manager.GenerationCacheController;
import com.ibm.pdp.generation.manager.GenerationCacheData;
import com.ibm.pdp.generation.manager.view.GenerationManagerView;
import com.ibm.pdp.generation.manager.view.Messages;
import com.ibm.pdp.references.ReferencesPlugin;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;

public class GenerationCacheRefreshAction
extends Action {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2022.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private GenerationManagerView view;
    public static final String _ID = String.valueOf(GenerationCacheRefreshAction.class.getName()) + "_ID";
    public static Job job;

    public GenerationCacheRefreshAction(GenerationManagerView genView) {
        this.view = genView;
        this.setText(Messages.GenerationCacheRefreshAction_Refresh);
        this.setId(_ID);
        this.setImageDescriptor(ReferencesPlugin.getDefault().getImageDescriptor("refresh"));
        this.setAccelerator(0x100000E);
    }

    public void run() {
        if (job != null) {
            job.cancel();
            job = null;
        }
        Job newJob = new Job(Messages.GenerationCacheRefreshAction_Create_cache){

            public IStatus run(IProgressMonitor monitor) {
                ArrayList<GenerationCacheData> cacheDatas;
                job = this;
                boolean refresh = true;
                GenerationCache gc = GenerationCacheController.getCache();
                if (gc != null && (cacheDatas = gc.getGenerationCacheDatas()) != null && cacheDatas.size() != 0) {
                    refresh = false;
                }
                GenerationCacheController.createGenerationCacheDatas(monitor);
                if (job == this) {
                    job = null;
                }
                class RefreshViewRunnable
                implements Runnable {
                    boolean resizeColumn = false;

                    public RefreshViewRunnable(boolean resizeColumn) {
                        this.resizeColumn = resizeColumn;
                    }

                    @Override
                    public void run() {
                        GenerationCacheRefreshAction.this.view.sort();
                        GenerationCacheRefreshAction.this.view.refresh(this.resizeColumn);
                    }
                }
                Display.getDefault().asyncExec((Runnable)new RefreshViewRunnable(refresh));
                return Status.OK_STATUS;
            }
        };
        newJob.setUser(true);
        newJob.schedule();
    }
}

