/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.generation.manager.view;

import com.ibm.pdp.generation.manager.GenerationCacheData;
import com.ibm.pdp.generation.manager.view.GenerationManagerView;
import com.ibm.pdp.generation.manager.view.Messages;
import java.util.List;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class GenerationCacheDataLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private GenerationManagerView viewer;

    public GenerationCacheDataLabelProvider(GenerationManagerView view) {
        this.viewer = view;
    }

    public Image getColumnImage(Object obj, int column) {
        return null;
    }

    public String getColumnText(Object obj, int column) {
        String label = "";
        if (obj instanceof GenerationCacheData) {
            GenerationCacheData gcd = (GenerationCacheData)obj;
            if (column == 0) {
                boolean shortLabel = this.viewer.tableColumnShortLabels[0];
                return gcd.getComputedShortDesignName(shortLabel);
            }
            if (column == 1) {
                boolean shortLabel = this.viewer.tableColumnShortLabels[1];
                return gcd.getComputedShortGeneratedProductFullName(shortLabel);
            }
            if (column == 2) {
                boolean shortLabel = this.viewer.tableColumnShortLabels[2];
                return gcd.getComputedShortPatternName(shortLabel);
            }
            if (column == 3) {
                boolean shortLabel = this.viewer.tableColumnShortLabels[3];
                return gcd.getComputedShortDesynchroMessage(shortLabel);
            }
            if (column == 4) {
                if (gcd.isMissingEntryPoint()) {
                    return Messages.GenerationCacheDataLabelProvider_NoEntryPoint;
                }
                if (gcd.isToReGenerate()) {
                    return Messages.GenerationCacheDataLabelProvider_To_regenerate;
                }
                if (gcd.getReActivateSynchronizationWorkItems() != null) {
                    List<String> list = gcd.getReActivateSynchronizationWorkItems();
                    StringBuilder sb = new StringBuilder();
                    for (String s : list) {
                        int index = s.indexOf(":");
                        if (index != -1) {
                            sb.append(' ');
                            sb.append(s.subSequence(0, index));
                            continue;
                        }
                        sb.append(s);
                    }
                    return NLS.bind((String)Messages.GenerationCacheDataLabelProvider_Work_items, (Object[])new String[]{sb.toString()});
                }
                return "";
            }
            if (column == 5) {
                return gcd.isDesignInError() ? Messages.GenerationCacheDataLabelProvider_Error_in_design : "";
            }
        }
        return label;
    }

    public String getModifiedDesign(Object obj, String separator, boolean full, boolean finalDots) {
        if (obj instanceof GenerationCacheData) {
            GenerationCacheData gcd = (GenerationCacheData)obj;
            List<String> modifiedDesigns = gcd.getModifiedDesigns();
            if (modifiedDesigns == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            int size = modifiedDesigns.size();
            if (size != 0) {
                String modifiedDesign = modifiedDesigns.get(0);
                if (full) {
                    modifiedDesign = GenerationCacheData.getShortNameForFile(modifiedDesign);
                }
                sb.append(modifiedDesign);
            }
            int i = 1;
            while (i < 10 && i < size) {
                sb.append(separator);
                String modifiedDesign = modifiedDesigns.get(i);
                if (full) {
                    modifiedDesign = GenerationCacheData.getShortNameForFile(modifiedDesign);
                }
                sb.append(modifiedDesign);
                ++i;
            }
            if (i == 10 && i != size && finalDots) {
                sb.append(separator);
                sb.append("...");
            }
            return sb.toString();
        }
        return null;
    }

    public String getToRegenerateDetailText(Object obj, String separator, boolean full, boolean finalDots) {
        if (obj instanceof GenerationCacheData) {
            GenerationCacheData gcd = (GenerationCacheData)obj;
            if (gcd.isMissingEntryPoint()) {
                return Messages.GenerationCacheDataLabelProvider_NoEntryPoint;
            }
            if (gcd.isToReGenerate()) {
                return Messages.GenerationCacheDataLabelProvider_To_regenerate;
            }
            List<String> workItems = gcd.getReActivateSynchronizationWorkItems();
            if (workItems != null) {
                StringBuilder sb = new StringBuilder();
                int size = workItems.size();
                if (size != 0) {
                    String wi = workItems.get(0);
                    sb.append(wi);
                }
                int i = 1;
                while (i < 10 && i < size) {
                    sb.append(separator);
                    String workItem = workItems.get(i);
                    sb.append(workItem);
                    ++i;
                }
                if (i == 10 && i != size && finalDots) {
                    sb.append(separator);
                    sb.append("...");
                }
                return sb.toString();
            }
        }
        return "";
    }
}

