/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.generation.manager;

import com.ibm.pdp.generation.manager.PdpFileGenerationLinksParser;
import com.ibm.pdp.generation.manager.PdpFileGenerationLinksParserResult;
import com.ibm.pdp.generation.manager.ResultReference;
import com.ibm.pdp.mdl.link.IVersionManagedTagHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class TagHandlerV0
implements IVersionManagedTagHandler {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    PdpFileGenerationLinksParser _parser;
    private String rank;

    TagHandlerV0(PdpFileGenerationLinksParser parser) {
        this._parser = parser;
    }

    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        String project;
        if (name.equals("GeneratedRefsSection")) {
            String patternGenStateVersion = atts.getValue("patternGenStateVersion");
            this.rank = null;
            this._parser.getResult().setPatternGenStateVersion(patternGenStateVersion);
        }
        if (name.equals("generation_output")) {
            project = atts.getValue("project");
            String packageLogicalMode = atts.getValue("logical_package");
            boolean isPackageLogicalMode = "Y".equals(packageLogicalMode);
            String packageName = atts.getValue("package");
            String refName = atts.getValue("name");
            String type = atts.getValue("type");
            String timesstamp = atts.getValue("timestamp");
            String relation = atts.getValue("relation");
            PdpFileGenerationLinksParserResult result = this._parser.getResult();
            ResultReference reference = new ResultReference(project, isPackageLogicalMode, packageName, null, refName, type, timesstamp, relation);
            result.setGenerationOutput(reference);
        } else if (name.equals("subRef")) {
            project = atts.getValue("project");
            String packageLogicalMode = atts.getValue("logical_package");
            boolean isPackageLogicalMode = "Y".equals(packageLogicalMode);
            String packageName = atts.getValue("package");
            String refName = atts.getValue("name");
            String type = atts.getValue("type");
            String timesstamp = atts.getValue("timestamp");
            String genStateId = atts.getValue("genId");
            String relation = atts.getValue("relation");
            if (relation != null && relation.endsWith("entrypoint")) {
                int indexOfRank = relation.indexOf("_");
                int endIndexOfRank = relation.lastIndexOf("_");
                if (indexOfRank >= 0 && endIndexOfRank >= 0 && endIndexOfRank > indexOfRank + 1) {
                    this.rank = relation.substring(indexOfRank + 1, endIndexOfRank);
                }
            }
            String metaType = atts.getValue("metaType");
            PdpFileGenerationLinksParserResult result = this._parser.getResult();
            ResultReference reference = new ResultReference(project, isPackageLogicalMode, packageName, metaType, refName, type, timesstamp, genStateId, relation);
            result.setRank(this.rank);
            result.getSubRefs().add(reference);
        }
    }
}

