/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.generation.manager;

import java.text.DateFormat;
import java.util.Date;
import java.util.List;

public class GenerationCacheData {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int _BY_DESIGN = 1;
    public static final int _BY_COBOL = 2;
    public static final int _BY_PATTERN = 3;
    public static final int _BY_DEPHASED_DESIGN = 4;
    public static final int _BY_REGENERATE = 5;
    public static final int _BY_ERROR = 6;
    private String generatedProductFullName;
    private String designName;
    private String patternName;
    private String desynchroMessage;
    private long lastGenerationDate;
    private boolean isDesignInError;
    private boolean isToReGenerate;
    private boolean isMissingEntryPoint;
    private List<String> reActivateSynchronizationWorkITem;
    private List<String> modifiedDesigns;

    public List<String> getReActivateSynchronizationWorkItems() {
        return this.reActivateSynchronizationWorkITem;
    }

    public void setReActivateSynchronizationWorkItems(List<String> reActivateSynchronizationWorkITem) {
        this.reActivateSynchronizationWorkITem = reActivateSynchronizationWorkITem;
    }

    public void setModifiedDesigns(List<String> modifiedDesigns) {
        this.modifiedDesigns = modifiedDesigns;
    }

    public List<String> getModifiedDesigns() {
        return this.modifiedDesigns;
    }

    public String getDesignName() {
        return this.designName;
    }

    public String getComputedShortDesignName(boolean shortLabel) {
        if (!shortLabel) {
            return this.getDesignName();
        }
        return GenerationCacheData.getShortNameForFile(this.getDesignName());
    }

    public String getDesynchroMessage() {
        return this.desynchroMessage;
    }

    public String getComputedShortDesynchroMessage(boolean shortLabel) {
        if (!shortLabel) {
            return this.getDesynchroMessage();
        }
        return GenerationCacheData.getShortNameForFile(this.getDesynchroMessage());
    }

    public String getGeneratedProductFullName() {
        return this.generatedProductFullName;
    }

    public String getComputedShortGeneratedProductFullName(boolean shortLabel) {
        if (!shortLabel) {
            return this.getGeneratedProductFullName();
        }
        return GenerationCacheData.getShortNameForFile(this.getGeneratedProductFullName());
    }

    public long getLastGenerationDate() {
        return this.lastGenerationDate;
    }

    public String getPatternName() {
        return this.patternName;
    }

    public String getComputedShortPatternName(boolean shortLabel) {
        if (!shortLabel) {
            return this.getPatternName();
        }
        String shortPatternName = this.getPatternName();
        int lastIndex = shortPatternName.lastIndexOf(".");
        if (lastIndex == -1 || lastIndex == shortPatternName.length() - 1) {
            return shortPatternName;
        }
        shortPatternName = shortPatternName.substring(lastIndex + 1);
        return shortPatternName;
    }

    public boolean isDesignInError() {
        return this.isDesignInError;
    }

    public boolean isMissingEntryPoint() {
        return this.isMissingEntryPoint;
    }

    public boolean isToReGenerate() {
        return this.isToReGenerate;
    }

    public void setDesignInError(boolean isDesignInError) {
        this.isDesignInError = isDesignInError;
    }

    public void setDesignName(String designName) {
        this.designName = designName;
    }

    public void setDesynchroMessage(String desynchroMessage) {
        this.desynchroMessage = desynchroMessage;
    }

    public void setGeneratedProductFullName(String generatedProductFullName) {
        this.generatedProductFullName = generatedProductFullName;
    }

    public void setLastGenerationDate(long lastGenerationDate) {
        this.lastGenerationDate = lastGenerationDate;
    }

    public void setPatternName(String patternName) {
        this.patternName = patternName;
    }

    public void setToReGenerate(boolean isToReGenerate) {
        this.isToReGenerate = isToReGenerate;
    }

    public void setMissingEntryPoint(boolean isMissingEntryPoint) {
        this.isMissingEntryPoint = isMissingEntryPoint;
    }

    public String getIdentifierForGeneration() {
        return String.valueOf(this.getDesignName()) + ":" + this.getPatternName();
    }

    public static String getShortNameForFile(String fileName) {
        String shortName = fileName;
        int lastIndex = shortName.lastIndexOf("/");
        if (lastIndex == -1 || lastIndex == shortName.length() - 1) {
            return shortName;
        }
        shortName = shortName.substring(lastIndex + 1);
        return shortName;
    }

    public String getPrintableLastGenerationDate() {
        Date date = new Date(this.lastGenerationDate);
        return this.lastGenerationDate == 0L ? "" : DateFormat.getDateTimeInstance(3, 2).format(date);
    }
}

