/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.generation.manager;

import com.ibm.pdp.explorer.model.service.PTModelService;
import com.ibm.pdp.framework.MigrationHelpTool;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.framework.pattern.PdpPatternGenStatesExceptions;
import com.ibm.pdp.generation.manager.GenerationCache;
import com.ibm.pdp.generation.manager.GenerationCacheData;
import com.ibm.pdp.generation.manager.Messages;
import com.ibm.pdp.generation.manager.PdpFileGenerationLinksParser;
import com.ibm.pdp.generation.manager.PdpFileGenerationLinksParserResult;
import com.ibm.pdp.generation.manager.view.GenerationManagerView;
import com.ibm.pdp.generation.menu.SynchronizationTool;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.meta.ArtifactState;
import com.ibm.pdp.mdl.meta.MetaFactory;
import com.ibm.pdp.mdl.meta.Property;
import com.ibm.pdp.mdl.meta.Reference;
import com.ibm.pdp.mdl.meta.io.MetadataStateAccess;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.statushandlers.StatusManager;

public class GenerationCacheController {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static GenerationCache generationCache;

    public static GenerationCache getCache() {
        if (generationCache == null) {
            generationCache = new GenerationCache();
        }
        return generationCache;
    }

    public static void createGenerationCacheDatas(IProgressMonitor monitor) {
        GenerationCacheController.createGenerationCacheDatas(true, monitor);
    }

    public static void createGenerationCacheDatas(boolean cacheDesignsIds, IProgressMonitor monitor) {
        if (GenerationCacheController.getCache() != null) {
            GenerationCacheController.getCache().setGenerationCacheDatas(null);
        }
        if (monitor != null) {
            monitor.setTaskName(Messages.GenerationCacheController_Finding_all_pdp);
        }
        MetadataStateAccess metadataStateAccess = MetadataStateAccess.getMetadataStateAccess();
        List existingArtifactStates = metadataStateAccess.queryArtifactStates((Query)new MatchAllDocsQuery());
        HashMap<String, String> genStateIDByLogicalName = new HashMap<String, String>();
        for (ArtifactState artifactState : existingArtifactStates) {
            String key = String.valueOf(artifactState.getArtifactId()) + "," + artifactState.getRank() + "," + artifactState.getPatternId() + "," + artifactState.getVersionId();
            String genStateId = artifactState.getStateId();
            genStateIDByLogicalName.put(key, genStateId);
        }
        ArrayList<ArtifactState> writeArtifactStates = new ArrayList<ArtifactState>();
        List pdpFiles = PdpTool.findAllPDPFiles((IProgressMonitor)monitor);
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        int size = pdpFiles.size();
        if (monitor != null) {
            monitor.beginTask("", size);
            monitor.setTaskName(Messages.GenerationCacheController_Computing_generation_state);
        }
        int i = 0;
        int step = size / 100;
        if (step == 0) {
            step = size / 10;
        }
        if (step == 0) {
            step = 1;
        }
        HashMap<String, String> stateIDByLogicalName = new HashMap<String, String>();
        for (IFile iFile : pdpFiles) {
            ArrayList<GenerationCacheData> generationCacheDatas;
            boolean isRegenerationRequired;
            boolean noEntryPoint;
            long timestamp;
            ArrayList<String> reactivatedWorkitems;
            ArrayList<String> modifiedDesigns;
            String patternName;
            String designID;
            String sourceFileLocation;
            block56: {
                ++i;
                String pdpFileLocation = iFile.getFullPath().toString();
                sourceFileLocation = PdpTool.computeSourceFileLocationFromPdpFileLocation((String)pdpFileLocation);
                designID = null;
                patternName = null;
                modifiedDesigns = null;
                reactivatedWorkitems = null;
                timestamp = 0L;
                InputStream is = null;
                noEntryPoint = false;
                try {
                    try {
                        PdpFileGenerationLinksParser parser = new PdpFileGenerationLinksParser();
                        is = iFile.getContents();
                        PdpFileGenerationLinksParserResult parserResult = parser.parse(is, null, true);
                        designID = parserResult.getMainRef().getTargetId();
                        patternName = parserResult.getPatternName();
                        if (parserResult.getLastGenerationDate() != null) {
                            timestamp = Long.parseLong(parserResult.getLastGenerationDate());
                        }
                        for (Reference ref : parserResult.getGenerationRefs()) {
                            String relativeFileName;
                            String genStateId;
                            String logicalFileName = ref.getTargetId();
                            String refStateId = ref.getStateId();
                            String stateIdFromDisk = null;
                            Property propGenStateID = ref.getProperty("genId");
                            String string = genStateId = propGenStateID == null ? null : propGenStateID.getValue();
                            if (genStateId == null || !PdpPatternGenStatesExceptions.isGenStateIDActivated) {
                                String relativeFileName2 = PdpTool.addRPPFolderToFileName((String)logicalFileName);
                                stateIdFromDisk = (String)stateIDByLogicalName.get(logicalFileName);
                                if (stateIdFromDisk == null) {
                                    stateIdFromDisk = PTModelService.getStateId((IPath)new Path(relativeFileName2));
                                    stateIDByLogicalName.put(logicalFileName, stateIdFromDisk);
                                }
                                ArrayList<String> reactivatedWorkitemsForOneReference = new ArrayList<String>();
                                boolean equivalent = SynchronizationTool.checkEquivalentId(refStateId, relativeFileName2, stateIdFromDisk, reactivatedWorkitemsForOneReference);
                                if (reactivatedWorkitemsForOneReference != null && reactivatedWorkitemsForOneReference.size() != 0) {
                                    if (reactivatedWorkitems == null) {
                                        reactivatedWorkitems = new ArrayList<String>();
                                    }
                                    for (String s : reactivatedWorkitemsForOneReference) {
                                        if (reactivatedWorkitems.contains(s)) continue;
                                        reactivatedWorkitems.add(s);
                                    }
                                }
                                if (equivalent) continue;
                                if (modifiedDesigns == null) {
                                    modifiedDesigns = new ArrayList<String>();
                                }
                                modifiedDesigns.add(logicalFileName.intern());
                                continue;
                            }
                            String patternGenStateVersion = parserResult.getPatternGenStateVersion();
                            String rank = parserResult.getRank();
                            String key = logicalFileName;
                            String lastVersion = PdpPatternGenStatesExceptions.getPatternGenStateLastVersion((String)patternName);
                            if (lastVersion != null) {
                                key = String.valueOf(logicalFileName) + "," + rank + "," + patternName + "," + patternGenStateVersion;
                            }
                            String genStateIDFromMap = (String)genStateIDByLogicalName.get(key);
                            String genStateId_ComputedOnFileOnDisk = null;
                            RadicalEntity re = null;
                            if (genStateIDFromMap != null) {
                                genStateId_ComputedOnFileOnDisk = genStateIDFromMap;
                            } else {
                                relativeFileName = PdpTool.addRPPFolderToFileName((String)logicalFileName);
                                if (lastVersion != null) {
                                    re = PTModelService.getResource((IPath)new Path(relativeFileName));
                                    if (re == null && designID == logicalFileName) {
                                        noEntryPoint = true;
                                    }
                                    if (re == null) {
                                        if (modifiedDesigns == null) {
                                            modifiedDesigns = new ArrayList();
                                        }
                                        modifiedDesigns.add(logicalFileName.intern());
                                        continue;
                                    }
                                    genStateId_ComputedOnFileOnDisk = PdpPatternGenStatesExceptions.getGenStateId((RadicalEntity)re, (String)patternName, (boolean)false, (String)patternGenStateVersion, (String)rank);
                                    if (genStateId_ComputedOnFileOnDisk == null) {
                                        StatusManager.getManager().handle((IStatus)new Status(4, "com.ibm.pdp.references", "genStateId is null for " + relativeFileName + " with pattern :" + patternName + ":" + patternGenStateVersion));
                                    } else {
                                        ArtifactState artifactState = MetaFactory.eINSTANCE.createArtifactState();
                                        artifactState.setArtifactId(re.getDesignId(re.getProject()));
                                        artifactState.setPatternId(patternName);
                                        artifactState.setVersionId(patternGenStateVersion);
                                        int rankInt = Integer.parseInt(rank);
                                        artifactState.setRank(rankInt);
                                        artifactState.setStateId(genStateId_ComputedOnFileOnDisk);
                                        writeArtifactStates.add(artifactState);
                                    }
                                }
                                genStateIDByLogicalName.put(key, genStateId_ComputedOnFileOnDisk);
                            }
                            if (genStateId.equals(genStateId_ComputedOnFileOnDisk)) continue;
                            relativeFileName = PdpTool.addRPPFolderToFileName((String)logicalFileName);
                            stateIdFromDisk = (String)stateIDByLogicalName.get(logicalFileName);
                            if (stateIdFromDisk == null) {
                                stateIdFromDisk = PTModelService.getStateId((IPath)new Path(relativeFileName));
                                stateIDByLogicalName.put(logicalFileName, stateIdFromDisk);
                            }
                            ArrayList<String> reactivatedWorkitemsForOneReference = new ArrayList<String>();
                            boolean equivalent = SynchronizationTool.checkEquivalentId(refStateId, relativeFileName, stateIdFromDisk, reactivatedWorkitemsForOneReference);
                            if (reactivatedWorkitemsForOneReference != null && reactivatedWorkitemsForOneReference.size() != 0) {
                                if (reactivatedWorkitems == null) {
                                    reactivatedWorkitems = new ArrayList();
                                }
                                for (String s : reactivatedWorkitemsForOneReference) {
                                    if (reactivatedWorkitems.contains(s)) continue;
                                    reactivatedWorkitems.add(s);
                                }
                            }
                            if (equivalent) continue;
                            if (modifiedDesigns == null) {
                                modifiedDesigns = new ArrayList();
                            }
                            modifiedDesigns.add(logicalFileName.intern());
                        }
                    }
                    catch (CoreException coreException) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block56;
                    }
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            String message = "";
            if (noEntryPoint) {
                message = (String)modifiedDesigns.get(0);
            }
            boolean bl = isRegenerationRequired = modifiedDesigns != null && modifiedDesigns.size() != 0;
            if (isRegenerationRequired && !noEntryPoint) {
                message = (String)modifiedDesigns.get(0);
                if (modifiedDesigns.size() > 1) {
                    message = String.valueOf(message) + " (+" + (modifiedDesigns.size() - 1) + ")";
                }
            }
            IPath path = PTModelService.getPath(designID);
            IFile file = PdpTool.getFile((IPath)path);
            boolean designInError = false;
            try {
                int severity = file.findMaxProblemSeverity(null, false, 0);
                designInError = severity == 2;
            }
            catch (CoreException coreException) {}
            GenerationCacheData gcd = new GenerationCacheData();
            gcd.setDesignName(designID);
            gcd.setGeneratedProductFullName(sourceFileLocation);
            gcd.setPatternName(patternName);
            gcd.setDesynchroMessage(message);
            gcd.setLastGenerationDate(timestamp);
            gcd.setDesignInError(designInError);
            if (!noEntryPoint) {
                gcd.setToReGenerate(isRegenerationRequired);
            }
            if (noEntryPoint) {
                gcd.setMissingEntryPoint(noEntryPoint);
            }
            if (reactivatedWorkitems != null && reactivatedWorkitems.size() != 0) {
                ArrayList<String> workItems = new ArrayList<String>();
                for (String rwi : reactivatedWorkitems) {
                    workItems.add(rwi);
                }
                gcd.setReActivateSynchronizationWorkItems(workItems);
            }
            if (cacheDesignsIds) {
                gcd.setModifiedDesigns((List<String>)modifiedDesigns);
            }
            if ((generationCacheDatas = GenerationCacheController.getCache().getGenerationCacheDatas()) == null) {
                generationCacheDatas = new ArrayList();
                GenerationCacheController.getCache().setGenerationCacheDatas(generationCacheDatas);
            }
            generationCacheDatas.add(gcd);
            if (monitor != null && i % step == 0) {
                monitor.worked(step);
            }
            if (monitor == null || !monitor.isCanceled()) continue;
            return;
        }
        metadataStateAccess.writeArtifactStates(writeArtifactStates);
    }

    public static void generateAll(List<?> list, IProgressMonitor monitor, GenerationManagerView view) throws Exception {
        class GenerateAll
        extends WorkspaceModifyOperation {
            List<?> myList;
            GenerationManagerView myView;
            StringBuilder sb;

            GenerateAll(List<?> list, GenerationManagerView gmv) {
                this.myList = list;
                this.myView = gmv;
            }

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                HashMap map = GenerationCacheController.getExtendedSelection(this.myList);
                if (map == null) {
                    return;
                }
                Iterator iter = map.keySet().iterator();
                monitor.beginTask(Messages.GenerationCacheController_Multiple_generation, map.size());
                this.sb = new StringBuilder();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    List list = (List)map.get(key);
                    GenerationCacheData gcd = (GenerationCacheData)list.get(0);
                    String generatedFile = gcd.getGeneratedProductFullName();
                    IController controller = MigrationHelpTool.reGenerate((String)generatedFile, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    if (controller == null) {
                        if (this.sb.length() == 0) {
                            this.sb.append(Messages.DEFAULT_MESS);
                            this.sb.append("\r\n");
                        }
                        this.sb.append(gcd.getDesignName());
                        this.sb.append("\r\n");
                        continue;
                    }
                    gcd.setDesynchroMessage("");
                    gcd.setToReGenerate(false);
                    long timestamp = controller.getGenerationLink().getGenerationTimeStamp();
                    gcd.setLastGenerationDate(timestamp);
                    if (list.size() <= 1) continue;
                    int i = 1;
                    while (i < list.size()) {
                        gcd = (GenerationCacheData)list.get(i);
                        gcd.setDesynchroMessage("");
                        gcd.setToReGenerate(false);
                        if (gcd.getLastGenerationDate() != 0L) {
                            gcd.setLastGenerationDate(timestamp);
                        }
                        ++i;
                    }
                }
                if (this.sb.length() != 0) {
                    this.sb.append("\r\n");
                    this.sb.append(Messages.SEE_ERROR_LOG_FOR_DETAILS);
                }
                if (this.myView != null) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (sb.length() != 0) {
                                String title = com.ibm.pdp.generation.menu.Messages.PacGeneratorLabels_GENERATION_PROCESS;
                                MessageDialog.openError(null, (String)title, (String)sb.toString());
                                PdpTool.openErrorLog();
                            }
                            myView.refresh(false);
                        }
                    });
                }
            }
        }
        GenerateAll va = new GenerateAll(list, view);
        if (PlatformUI.isWorkbenchRunning()) {
            IWorkbench wb = PlatformUI.getWorkbench();
            IProgressService ps = wb.getProgressService();
            try {
                ps.busyCursorWhile((IRunnableWithProgress)va);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            va.execute(monitor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static HashMap<String, List<GenerationCacheData>> getExtendedSelection(List<?> datas) {
        if (datas == null || datas.size() == 0) {
            return null;
        }
        HashMap<String, List<GenerationCacheData>> result = new HashMap<String, List<GenerationCacheData>>(datas.size());
        for (GenerationCacheData gcd : datas) {
            String key = gcd.getIdentifierForGeneration();
            List<GenerationCacheData> list = result.get(key);
            if (list == null) {
                list = new ArrayList<GenerationCacheData>();
                result.put(key, list);
            }
            list.add(gcd);
        }
        if (generationCache == null) {
            return result;
        }
        for (GenerationCacheData gcd : generationCache.getGenerationCacheDatas()) {
            String key = gcd.getIdentifierForGeneration();
            List<GenerationCacheData> list = result.get(key);
            if (list == null || list.contains(gcd)) continue;
            if (!gcd.getGeneratedProductFullName().toUpperCase().endsWith("CBL")) {
                list.add(0, gcd);
                continue;
            }
            list.add(gcd);
        }
        return result;
    }
}

