/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.generation.manager;

import com.ibm.pdp.explorer.view.tool.PTAttributeItem;
import com.ibm.pdp.explorer.wizard.PTWizardLabel;
import com.ibm.pdp.generation.manager.GenerationCacheData;
import com.ibm.pdp.generation.manager.Messages;
import com.ibm.pdp.util.Util;
import com.ibm.pdp.util.csv.CsvWriter;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class GenerationCache {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ArrayList<GenerationCacheData> gcDatas;
    private static int ASC = 1;
    private static int DSC = -1;
    private static GenerationCacheDataComparator gcdc = null;
    private static final int _BUFFER_SIZE = 10000;

    public ArrayList<GenerationCacheData> getGenerationCacheDatas() {
        return this.gcDatas;
    }

    public void setGenerationCacheDatas(ArrayList<GenerationCacheData> gcDatas) {
        this.gcDatas = gcDatas;
    }

    public void sort(int columnID, boolean direction, boolean shortLabel) {
        if (this.gcDatas == null) {
            return;
        }
        if (gcdc == null) {
            gcdc = new GenerationCacheDataComparator();
        }
        gcdc.setDirection(direction);
        gcdc.setFieldToCompare(columnID);
        gcdc.setShortLabel(shortLabel);
        Collections.sort(this.gcDatas, gcdc);
    }

    public void serializeDatas(List<PTAttributeItem> preferredAttributes, String outputFile) {
        String lineSeparator;
        ByteArrayOutputStream csvStream = new ByteArrayOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(csvStream), 10000);
        String separator = PTWizardLabel.getString((String)PTWizardLabel._CSV_SEPARATOR);
        char csvSep = ',';
        if (separator.length() > 0) {
            csvSep = separator.charAt(0);
        }
        if ((lineSeparator = System.getProperty("line.separator")) == null) {
            lineSeparator = "\n";
        }
        CsvWriter csvWriter = new CsvWriter((Writer)writer, csvSep, '\"', lineSeparator);
        for (PTAttributeItem attribute : preferredAttributes) {
            csvWriter.addCell(attribute.getLabel());
            if (!attribute.getId().equals("DephasedDesign")) continue;
            csvWriter.addCell(Messages.GenerationCache_Nb_modified_design);
        }
        csvWriter.endOfRow();
        ArrayList<GenerationCacheData> datas = this.getGenerationCacheDatas();
        if (datas != null && datas.size() != 0) {
            for (GenerationCacheData gcData : datas) {
                for (PTAttributeItem attribute : preferredAttributes) {
                    if (attribute.getId().equals("Design")) {
                        csvWriter.addCell(gcData.getDesignName());
                        continue;
                    }
                    if (attribute.getId().equals("Cobol")) {
                        csvWriter.addCell(gcData.getGeneratedProductFullName());
                        continue;
                    }
                    if (attribute.getId().equals("Pattern")) {
                        csvWriter.addCell(gcData.getPatternName());
                        continue;
                    }
                    if (attribute.getId().equals("DephasedDesign")) {
                        int size = 0;
                        List<String> list = gcData.getModifiedDesigns();
                        if (list != null) {
                            StringBuilder sb = new StringBuilder();
                            if (list.size() > 0) {
                                sb.append(list.get(0));
                            }
                            int i = 1;
                            while (i < list.size()) {
                                sb.append(lineSeparator);
                                sb.append(list.get(i));
                                ++i;
                            }
                            csvWriter.addCell(sb.toString());
                            size = list.size();
                        } else {
                            csvWriter.addCell("");
                        }
                        csvWriter.addCell(size != 0 ? "" + size : "");
                        continue;
                    }
                    if (attribute.getId().equals("ToRegenerate")) {
                        if (gcData.isToReGenerate()) {
                            csvWriter.addCell(Messages.GenerationCache_To_regenerate);
                        } else {
                            List<String> workItems = gcData.getReActivateSynchronizationWorkItems();
                            if (workItems != null) {
                                StringBuilder sb = new StringBuilder();
                                for (String s : workItems) {
                                    int index = s.indexOf(":");
                                    if (index != -1) {
                                        sb.append(' ');
                                        sb.append(s.subSequence(0, index));
                                        continue;
                                    }
                                    sb.append(s);
                                }
                                csvWriter.addCell(NLS.bind((String)Messages.GenerationCache_Work_items, (Object[])new String[]{sb.toString()}));
                            } else {
                                csvWriter.addCell("");
                            }
                        }
                        csvWriter.addCell(gcData.isToReGenerate() ? Messages.GenerationCache_Yes : Messages.GenerationCache_No);
                        continue;
                    }
                    if (!attribute.getId().equals("ErrorInDesign")) continue;
                    csvWriter.addCell(gcData.isDesignInError() ? Messages.GenerationCache_Yes : Messages.GenerationCache_No);
                }
                csvWriter.endOfRow();
            }
        }
        csvWriter.close();
        try {
            FileOutputStream fos = new FileOutputStream(outputFile);
            BufferedOutputStream outputStreamBuffer = new BufferedOutputStream(fos, 10000);
            outputStreamBuffer.write(csvStream.toByteArray());
            outputStreamBuffer.close();
            fos.close();
        }
        catch (IOException e) {
            Util.rethrow((Throwable)e);
        }
    }

    class GenerationCacheDataComparator
    implements Comparator<GenerationCacheData> {
        int _direction = GenerationCache.access$0();
        int _comparisonType = 1;
        boolean _shortLabel = false;

        GenerationCacheDataComparator() {
        }

        @Override
        public int compare(GenerationCacheData o1, GenerationCacheData o2) {
            int result = 0;
            if (this._comparisonType == 1) {
                result = o1.getComputedShortDesignName(this._shortLabel).compareTo(o2.getComputedShortDesignName(this._shortLabel));
            }
            if (this._comparisonType == 2) {
                result = o1.getComputedShortGeneratedProductFullName(this._shortLabel).compareTo(o2.getComputedShortGeneratedProductFullName(this._shortLabel));
            }
            if (this._comparisonType == 3) {
                result = o1.getComputedShortPatternName(this._shortLabel).compareTo(o2.getComputedShortPatternName(this._shortLabel));
            }
            if (this._comparisonType == 4) {
                result = o1.getComputedShortDesynchroMessage(this._shortLabel).compareTo(o2.getComputedShortDesynchroMessage(this._shortLabel));
            }
            if (this._comparisonType == 5) {
                if (!o1.isToReGenerate() && !o2.isToReGenerate()) {
                    List<String> w1 = o1.getReActivateSynchronizationWorkItems();
                    List<String> w2 = o2.getReActivateSynchronizationWorkItems();
                    if (w1 == null) {
                        if (w2 == null) {
                            return 0;
                        }
                        result = -1;
                    } else if (w2 == null) {
                        result = 1;
                    } else {
                        String w1S = this.convertToString(w1);
                        String w2S = this.convertToString(w2);
                        result = w1S.compareTo(w2S);
                    }
                } else {
                    if (o1.isToReGenerate() && o2.isToReGenerate()) {
                        return 0;
                    }
                    int n = result = o2.isToReGenerate() ? -1 : 1;
                }
            }
            if (this._comparisonType == 6) {
                if (o1.isDesignInError() == o2.isDesignInError()) {
                    return 0;
                }
                result = o2.isDesignInError() ? 1 : -1;
            }
            return result * this._direction;
        }

        private String convertToString(List<String> w1) {
            StringBuilder sb = new StringBuilder();
            for (String s : w1) {
                sb.append(s);
            }
            return sb.toString();
        }

        public void setShortLabel(boolean shortLabel) {
            this._shortLabel = shortLabel;
        }

        public void setDirection(boolean ascending) {
            this._direction = ascending ? ASC : DSC;
        }

        public void setFieldToCompare(int comparisonType) {
            this._comparisonType = comparisonType;
        }
    }
}

