/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.generation.manager;

import com.ibm.pdp.generation.manager.EquivalentStateIdCache;
import com.ibm.pdp.util.Util;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.core.runtime.Platform;

public class EquivalentStateIdCacheSerializer {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public boolean serialize(EquivalentStateIdCache esiCache, String fileName) {
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        XMLStreamWriter xmlWriter = null;
        FileWriter fw = null;
        try {
            try {
                fw = new FileWriter(fileName);
                BufferedWriter bf = new BufferedWriter(fw);
                xmlWriter = outputFactory.createXMLStreamWriter(bf);
                xmlWriter.writeStartDocument("ISO-8859-1", "1.0");
                xmlWriter.writeStartElement("EquivalentStateCache");
                xmlWriter.writeAttribute("Version", "1");
                this.serialize(esiCache, xmlWriter);
                xmlWriter.writeEndElement();
            }
            catch (XMLStreamException e) {
                Util.rethrow((Throwable)e);
                if (xmlWriter != null) {
                    try {
                        xmlWriter.flush();
                        xmlWriter.close();
                    }
                    catch (XMLStreamException e2) {
                        Util.rethrow((Throwable)e2);
                    }
                }
                try {
                    if (fw != null) {
                        fw.close();
                    }
                }
                catch (IOException e3) {
                    Util.rethrow((Throwable)e3);
                }
            }
            catch (IOException e) {
                block29: {
                    System.out.println("File " + fileName + " could not be saved. Error mess : " + e.getMessage());
                    if (xmlWriter == null) break block29;
                    try {
                        xmlWriter.flush();
                        xmlWriter.close();
                    }
                    catch (XMLStreamException e4) {
                        Util.rethrow((Throwable)e4);
                    }
                }
                try {
                    if (fw != null) {
                        fw.close();
                    }
                }
                catch (IOException e5) {
                    Util.rethrow((Throwable)e5);
                }
            }
        }
        finally {
            if (xmlWriter != null) {
                try {
                    xmlWriter.flush();
                    xmlWriter.close();
                }
                catch (XMLStreamException e) {
                    Util.rethrow((Throwable)e);
                }
            }
            try {
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException e) {
                Util.rethrow((Throwable)e);
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private void serialize(EquivalentStateIdCache esiCache, XMLStreamWriter xmlWriter) throws XMLStreamException {
        designIdIterator = esiCache.getAllDesignIdIterator();
        if (designIdIterator != null) ** GOTO lbl19
        return;
lbl-1000:
        // 1 sources

        {
            designId = designIdIterator.next();
            esiIterator = esiCache.getEquivalentStateIdForDesignId(designId);
            if (esiIterator == null) continue;
            xmlWriter.writeStartElement("EquivalentStateIDs");
            xmlWriter.writeAttribute("DesignId", designId);
            while (esiIterator.hasNext()) {
                equivalentStateId = esiIterator.next();
                xmlWriter.writeStartElement("EquivalentStateID");
                xmlWriter.writeAttribute("AfterStateId", equivalentStateId.getAfterStateId());
                xmlWriter.writeAttribute("BeforeStateId", equivalentStateId.getBeforeStateId());
                xmlWriter.writeAttribute("WorkItemNumber", String.valueOf(equivalentStateId.getWorkItemNumber()));
                xmlWriter.writeAttribute("WorkItemTitle", equivalentStateId.getWorkItemTitle());
                xmlWriter.writeEndElement();
            }
            xmlWriter.writeEndElement();
lbl19:
            // 3 sources

            ** while (designIdIterator.hasNext())
        }
lbl20:
        // 1 sources

    }

    public static String getDefaultEquivalentStateIdCacheFileName() {
        return String.valueOf(Platform.getInstanceLocation().getURL().getPath()) + ".metadata/" + "EquivalentStateId.xml";
    }
}

