/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.generation.manager;

import com.ibm.pdp.generation.manager.EquivalentStateIdCache;
import com.ibm.pdp.util.Util;
import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class EquivalentStateIdCacheDeserializer {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void deserialize(InputStream is) {
        block27: {
            EquivalentStateIdCache esIdCache = new EquivalentStateIdCache();
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            XMLStreamReader xmlReader = null;
            try {
                try {
                    xmlReader = inputFactory.createXMLStreamReader(is);
                    String localName = "";
                    boolean finished = false;
                    String designId = "";
                    while (xmlReader.hasNext() && !finished) {
                        int eventType = xmlReader.next();
                        if (eventType == 1) {
                            localName = xmlReader.getLocalName();
                            if (localName.equalsIgnoreCase("EquivalentStateCache")) {
                                String version = "";
                                int nbOfAtt = xmlReader.getAttributeCount();
                                int i = 0;
                                while (i < nbOfAtt) {
                                    String name = xmlReader.getAttributeLocalName(i);
                                    String value = xmlReader.getAttributeValue(i);
                                    if (name.equalsIgnoreCase("Version") && !(version = value).equals("1")) {
                                        throw new RuntimeException("Equivalent State Cache version not known :" + version);
                                    }
                                    ++i;
                                }
                                continue;
                            }
                            if (localName.equalsIgnoreCase("EquivalentStateIDs")) {
                                int nbOfAtt = xmlReader.getAttributeCount();
                                int i = 0;
                                while (i < nbOfAtt) {
                                    String name = xmlReader.getAttributeLocalName(i);
                                    String value = xmlReader.getAttributeValue(i);
                                    if (name.equalsIgnoreCase("DesignId")) {
                                        designId = value;
                                    }
                                    ++i;
                                }
                                continue;
                            }
                            if (!localName.equalsIgnoreCase("EquivalentStateID")) continue;
                            String afterStateId = "";
                            String beforeStateId = "";
                            int workItemNumber = 0;
                            String workItemTitle = "";
                            int nbOfAtt = xmlReader.getAttributeCount();
                            int i = 0;
                            while (i < nbOfAtt) {
                                String name = xmlReader.getAttributeLocalName(i);
                                String value = xmlReader.getAttributeValue(i);
                                if (name.equalsIgnoreCase("AfterStateId")) {
                                    afterStateId = value;
                                }
                                if (name.equalsIgnoreCase("BeforeStateId")) {
                                    beforeStateId = value;
                                }
                                if (name.equalsIgnoreCase("WorkItemNumber")) {
                                    workItemNumber = Integer.parseInt(value);
                                }
                                if (name.equalsIgnoreCase("WorkItemTitle")) {
                                    workItemTitle = value;
                                }
                                ++i;
                            }
                            esIdCache.addEquivalentStateId(designId, beforeStateId, afterStateId, workItemNumber, workItemTitle);
                            continue;
                        }
                        if (eventType == 2 || eventType == 5 || eventType == 4 || eventType == 12 || eventType != 8) continue;
                        EquivalentStateIdCache.setCurrentEquivalentStateIdCache(esIdCache);
                    }
                }
                catch (XMLStreamException f) {
                    Util.rethrow((Throwable)f);
                    if (xmlReader != null) {
                        try {
                            xmlReader.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block27;
                }
            }
            catch (Throwable throwable) {
                if (xmlReader != null) {
                    try {
                        xmlReader.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (xmlReader != null) {
                try {
                    xmlReader.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

