/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.generation.manager;

import com.ibm.pdp.generation.manager.EquivalentStateId;
import com.ibm.pdp.generation.manager.EquivalentStateIdCacheDeserializer;
import com.ibm.pdp.generation.manager.EquivalentStateIdCacheSerializer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class EquivalentStateIdCache {
    private static EquivalentStateIdCache cache;
    private static boolean cacheLoaded;
    private HashMap<String, List<EquivalentStateId>> map;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    static {
        cacheLoaded = false;
    }

    public void addEquivalentStateId(String designId, String beforeStateId, String afterStateId, int workItemNumber, String workItemTitle) {
        List<EquivalentStateId> list;
        EquivalentStateId esi = new EquivalentStateId(beforeStateId, afterStateId, workItemNumber, workItemTitle);
        if (this.map == null) {
            this.map = new HashMap();
        }
        if ((list = this.map.get(designId)) == null) {
            list = new ArrayList<EquivalentStateId>();
            list.add(esi);
        } else {
            list.add(esi);
        }
        this.map.put(designId, list);
    }

    public Iterator<String> getAllDesignIdIterator() {
        if (this.map == null) {
            return null;
        }
        return this.map.keySet().iterator();
    }

    public Iterator<EquivalentStateId> getEquivalentStateIdForDesignId(String designId) {
        if (this.map == null) {
            return null;
        }
        List<EquivalentStateId> list = this.map.get(designId);
        if (list == null) {
            return null;
        }
        return list.iterator();
    }

    public static EquivalentStateIdCache getCurrentEquivalentStateIdCache() {
        if (cache == null && !cacheLoaded) {
            EquivalentStateIdCache.loadEquivalentStateIdCache();
            cacheLoaded = true;
        }
        return cache;
    }

    public static void setCurrentEquivalentStateIdCache(EquivalentStateIdCache esIdCache) {
        cache = esIdCache;
    }

    public static void loadEquivalentStateIdCache() {
        String EquivalentStateIdCacheFileName = EquivalentStateIdCacheSerializer.getDefaultEquivalentStateIdCacheFileName();
        File file = new File(EquivalentStateIdCacheFileName);
        if (file.exists()) {
            EquivalentStateIdCacheDeserializer esIdCacheDeserializer = new EquivalentStateIdCacheDeserializer();
            try {
                esIdCacheDeserializer.deserialize(new FileInputStream(file));
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
    }
}

