/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.qualitycontrol.sdk.sourcecode.rules;

import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.TextStatus;
import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.qualitycontrol.sdk.sourcecode.provider.AbstractSourceCodeRule;
import com.ibm.pdp.qualitycontrol.sdk.sourcecode.provider.SourceCodeResource;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import java.util.Iterator;

public class NoGeneratedCodeOverrideRule
extends AbstractSourceCodeRule {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void analyzeResource(AnalysisHistory history, SourceCodeResource resource) {
        this.findOverwrittenGeneratedLines(history, resource);
    }

    protected void findOverwrittenGeneratedLines(AnalysisHistory history, SourceCodeResource resource) {
        IEditTree editTree = resource.getEditTree();
        Iterator rootNodes = editTree.rootNodes();
        while (rootNodes.hasNext()) {
            this.findOverwrittenGeneratedLinesInto((ITextNode)rootNodes.next(), history, resource);
        }
    }

    protected void findOverwrittenGeneratedLinesInto(ITextNode node, AnalysisHistory history, SourceCodeResource sourceCodeResource) {
        IGeneratedTag tag;
        TextStatus status = node.getTextStatus();
        if ((status == TextStatus.Deleted || status == TextStatus.Modified) && (tag = node.enclosingGeneratedTag()) != null) {
            int beginIdx = node.beginIndex();
            int lineRank = sourceCodeResource.lineRankFromCharIndex(beginIdx);
            this.addViolation(history, 1 + lineRank, beginIdx, node.endIndex() - beginIdx, sourceCodeResource);
        }
        if (!node.includeUserSubNode()) {
            return;
        }
        Iterator subnodes = node.sons();
        while (subnodes.hasNext()) {
            this.findOverwrittenGeneratedLinesInto((ITextNode)subnodes.next(), history, sourceCodeResource);
        }
    }
}

