/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.qualitycontrol.sdk.sourcecode.provider;

import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.framework.ControllerFactory;
import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.qualitycontrol.sdk.sourcecode.provider.AbstractSourceCodeRule;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class SourceCodeResource {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IResource resource;
    private int[] lineStartIndexes;
    IController controler = null;
    private IEditTree editTree;
    private String designId;

    public SourceCodeResource(IResource resourceValue) {
        this.resource = resourceValue;
    }

    public IResource getResource() {
        return this.resource;
    }

    public CharSequence getText() {
        return this.getEditTree().getTextProcessor().getText();
    }

    public IEditTree getEditTree() {
        if (this.editTree == null) {
            this.editTree = this.getController().getTextProcessor().getEditTree();
        }
        return this.editTree;
    }

    public String getDesignId() {
        if (this.designId == null) {
            this.designId = this.getController().getDesignLink().getFileId();
        }
        return this.designId;
    }

    public int lineRankFromCharIndex(int charIndex) {
        int[] lineStartIndexes = this.getLineStartIndexes();
        return SourceCodeResource.lineRankFromIndex(charIndex, lineStartIndexes, 0, lineStartIndexes.length);
    }

    public IController getController() {
        IResource resource = this.getResource();
        if (this.controler == null && resource != null && resource instanceof IFile && !"cbl".equals(((IFile)resource).getFileExtension()) && !"cpy".equals(((IFile)resource).getFileExtension())) {
            this.controler = ControllerFactory.getInstance().getController(resource.getFullPath().toString());
        }
        return this.controler;
    }

    private static int lineRankFromIndex(int index, int[] lineStartIndexes, int begin, int end) {
        while (begin < end) {
            int middle = begin + end >>> 1;
            int value = lineStartIndexes[middle];
            if (index > value) {
                begin = middle + 1;
                continue;
            }
            if (index < value) {
                end = middle;
                continue;
            }
            return middle;
        }
        return ~begin;
    }

    private int[] getLineStartIndexes() {
        if (this.lineStartIndexes == null) {
            this.lineStartIndexes = this.computeLineIndexes(this.getText());
        }
        return this.lineStartIndexes;
    }

    private int[] computeLineIndexes(CharSequence s) {
        if (s.length() == 0) {
            return new int[0];
        }
        int[] lines = new int[1 + s.length() / 80];
        lines[0] = 0;
        int nbLines = 1;
        int index = this.nextLineStartIndex(s, 0);
        while (index != -1) {
            if (nbLines == lines.length) {
                int[] newLines = new int[nbLines + (nbLines >> 3) + 10];
                System.arraycopy(lines, 0, newLines, 0, nbLines);
                lines = newLines;
            }
            lines[nbLines++] = index;
            index = this.nextLineStartIndex(s, index);
        }
        if (nbLines != lines.length) {
            int[] newLines = new int[nbLines];
            System.arraycopy(lines, 0, newLines, 0, nbLines);
            lines = newLines;
        }
        return lines;
    }

    private int nextLineStartIndex(CharSequence s, int index) {
        int length = s.length();
        while (index < length) {
            char c = s.charAt(index);
            if (c == '\r') {
                if (++index < length && s.charAt(index) == '\n') {
                    ++index;
                }
                return index;
            }
            if (c == '\n') {
                if (++index < length && s.charAt(index) == '\r') {
                    ++index;
                }
                return index;
            }
            ++index;
        }
        return -1;
    }

    protected static abstract class SourceCodeHandler {
        public abstract boolean analyze(AbstractSourceCodeRule var1, SourceCodeResource var2);
    }
}

