/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.qualitycontrol.sdk.sourcecode.provider;

import com.ibm.pdp.qualitycontrol.sdk.sourcecode.provider.SourceCodeResource;
import com.ibm.rsaz.analysis.core.category.DefaultAnalysisCategory;
import com.ibm.rsaz.analysis.core.data.AnalysisDataCollectorsManager;
import com.ibm.rsaz.analysis.core.data.DataCollector;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.provider.AbstractAnalysisProvider;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;

public class SourceCodeCodeReviewProvider
extends AbstractAnalysisProvider {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String DEFINED_ID = "com.ibm.pdp.qualitycontrol.sdk.sourcecode.provider.collector";
    public static final String RESOURCE_PROPERTY = "SourceCodeResource";
    private static final int PROGRESS_SCALE = 10;

    public void analyze(IProgressMonitor monitor, AnalysisHistory history) {
        try {
            DataCollector artifactDataCollector = AnalysisDataCollectorsManager.getDataCollector((String)DEFINED_ID);
            List resources = (List)artifactDataCollector.getAnalysisData();
            if (monitor.isCanceled()) {
                return;
            }
            history.setAnalyzedResources(resources);
            Collection selectedCategories = this.getSelectedCategories(history);
            monitor.beginTask(this.getLabel(), resources.size() * selectedCategories.size() * 10);
            if (monitor.isCanceled()) {
                return;
            }
            for (IResource resource : resources) {
                SourceCodeResource sourceCodeResource = new SourceCodeResource(resource);
                this.setProperty(history.getHistoryId(), RESOURCE_PROPERTY, sourceCodeResource);
                monitor.subTask(sourceCodeResource.getResource().getName());
                for (DefaultAnalysisCategory category : selectedCategories) {
                    try {
                        category.analyze(history, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        monitor.done();
                        this.removeProperty(history.getHistoryId(), RESOURCE_PROPERTY);
                        this.tearDown();
                        return;
                    }
                    if (!monitor.isCanceled()) continue;
                    return;
                }
                monitor.worked(10);
                if (!monitor.isCanceled()) continue;
                return;
            }
        }
        finally {
            monitor.done();
            this.removeProperty(history.getHistoryId(), RESOURCE_PROPERTY);
            this.tearDown();
        }
    }
}

