/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.qualitycontrol.design.provider;

import com.ibm.pdp.maf.rpp.kernel.MetaEntity;
import com.ibm.pdp.maf.rpp.kernel.RadicalElement;
import com.ibm.pdp.maf.rpp.pac.blockbase.CodasylBlockBase;
import com.ibm.pdp.maf.rpp.pac.blockbase.HierarchicalBlockBase;
import com.ibm.pdp.maf.rpp.pac.blockbase.RelationalBlockBase;
import com.ibm.pdp.maf.rpp.pac.blockbase.SocrateBlockBase;
import com.ibm.pdp.maf.rpp.pac.copybook.Copybook;
import com.ibm.pdp.maf.rpp.pac.dataelement.DataElement;
import com.ibm.pdp.maf.rpp.pac.datastructure.DataStructure;
import com.ibm.pdp.maf.rpp.pac.dialog.Dialog;
import com.ibm.pdp.maf.rpp.pac.dialog.Screen;
import com.ibm.pdp.maf.rpp.pac.dialogcommunicationmonitor.CommunicationMonitor;
import com.ibm.pdp.maf.rpp.pac.dialogcommunicationmonitor.DialogCommunicationMonitor;
import com.ibm.pdp.maf.rpp.pac.dialogfolder.DialogFolder;
import com.ibm.pdp.maf.rpp.pac.dialogfolder.Folder;
import com.ibm.pdp.maf.rpp.pac.dialogfolderview.DialogFolderView;
import com.ibm.pdp.maf.rpp.pac.dialogfolderview.FolderView;
import com.ibm.pdp.maf.rpp.pac.dialogserver.DialogServer;
import com.ibm.pdp.maf.rpp.pac.dialogserver.Server;
import com.ibm.pdp.maf.rpp.pac.library.Library;
import com.ibm.pdp.maf.rpp.pac.macro.Macro;
import com.ibm.pdp.maf.rpp.pac.program.Program;
import com.ibm.pdp.maf.rpp.pac.report.Report;
import com.ibm.pdp.maf.rpp.pac.segment.LogicalView;
import com.ibm.pdp.maf.rpp.pac.segment.MonoStructureSegment;
import com.ibm.pdp.maf.rpp.pac.segment.StandardSegment;
import com.ibm.pdp.maf.rpp.pac.segment.Table;
import com.ibm.pdp.maf.rpp.pac.text.Text;
import com.ibm.pdp.maf.rpp.service.IMAFModelService;
import com.ibm.pdp.maf.rpp.service.MAFModelService;
import com.ibm.pdp.pdppath.service.PdpPathService;
import com.ibm.pdp.qualitycontrol.design.provider.AbstractDesignRule;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class DesignEntityResource {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final Map<String, DesignEntityHandler> entityHandlers = new HashMap<String, DesignEntityHandler>();
    protected IResource resource;
    protected String extension;
    protected DesignEntityHandler entityHandler;
    protected RadicalElement designEntity;

    static {
        entityHandlers.put("dataaggregate", new DesignEntityHandler(){

            @Override
            public RadicalElement getRadicalElement(DesignEntityResource resource) {
                StandardSegment as = this.getModelService().getStandardSegment(resource.getProjectName(), resource.getPackageName(), resource.getEntityName());
                if (as != null) {
                    return as;
                }
                as = this.getModelService().getMonoStructureSegment(resource.getProjectName(), resource.getPackageName(), resource.getEntityName());
                if (as != null) {
                    return as;
                }
                as = this.getModelService().getLogicalView(resource.getProjectName(), resource.getPackageName(), resource.getEntityName());
                if (as != null) {
                    return as;
                }
                return this.getModelService().getTable(resource.getProjectName(), resource.getPackageName(), resource.getEntityName());
            }

            @Override
            public boolean analyze(AbstractDesignRule rule, DesignEntityResource resource) {
                RadicalElement radical = resource.getRadicalElement();
                if (radical instanceof StandardSegment) {
                    return rule.analyzeSegment(resource);
                }
                if (radical instanceof MonoStructureSegment) {
                    return rule.analyzeMonoStructureSegment(resource);
                }
                if (radical instanceof LogicalView) {
                    return rule.analyzeLogicalViewSegment(resource);
                }
                if (radical instanceof Table) {
                    return rule.analyzeTableSegment(resource);
                }
                return true;
            }
        });
        entityHandlers.put("dataelement", new DesignEntityHandler(){

            @Override
            public RadicalElement getRadicalElement(DesignEntityResource resource) {
                return this.getModelService().getDataElement(resource.getProjectName(), resource.getPackageName(), resource.getEntityName());
            }

            @Override
            public boolean analyze(AbstractDesignRule rule, DesignEntityResource resource) {
                return rule.analyzeDataElement(resource);
            }
        });
        entityHandlers.put("dataunit", new DesignEntityHandler(){

            @Override
            public RadicalElement getRadicalElement(DesignEntityResource resource) {
                DataStructure element = this.getModelService().getDataStructure(resource.getProjectName(), resource.getPackageName(), resource.getEntityName());
                if (element != null) {
                    return element;
                }
                element = this.getModelService().getTable(resource.getProjectName(), resource.getPackageName(), resource.getEntityName());
                if (element != null) {
                    return element;
                }
                return this.getModelService().getLogicalView(resource.getProjectName(), resource.getPackageName(), resource.getEntityName());
            }

            @Override
            public boolean analyze(AbstractDesignRule rule, DesignEntityResource resource) {
                return rule.analyzeDataStructure(resource);
            }
        });
        entityHandlers.put("metaentity", new DesignEntityHandler(){

            @Override
            public RadicalElement getRadicalElement(DesignEntityResource resource) {
                return this.getModelService().getMetaEntity(resource.getProjectName(), resource.getPackageName(), resource.getEntityName());
            }

            @Override
            public boolean analyze(AbstractDesignRule rule, DesignEntityResource resource) {
                return rule.analyzeMetaEntity(resource);
            }
        });
        entityHandlers.put("metaentitytype", new DesignEntityHandler(){

            @Override
            public RadicalElement getRadicalElement(DesignEntityResource resource) {
                return this.getModelService().getMetaEntityType(resource.getProjectName(), resource.getPackageName(), resource.getEntityName());
            }

            @Override
            public boolean analyze(AbstractDesignRule rule, DesignEntityResource resource) {
                return rule.analyzeMetaEntityType(resource);
            }
        });
        entityHandlers.put("userentity", new DesignEntityHandler(){

            @Override
            public RadicalElement getRadicalElement(DesignEntityResource resource) {
                return this.getModelService().getUserEntity(resource.getProjectName(), resource.getPackageName(), resource.getMetaType(), resource.getEntityName());
            }

            @Override
            public boolean analyze(AbstractDesignRule rule, DesignEntityResource resource) {
                return rule.analyzeUserEntity(resource);
            }
        });
        entityHandlers.put("metadataaggregate", new DesignEntityHandler(){

            @Override
            public RadicalElement getRadicalElement(DesignEntityResource resource) {
                return this.getModelService().getMetaDataAggregate(resource.getProjectName(), resource.getPackageName(), resource.getEntityName());
            }

            @Override
            public boolean analyze(AbstractDesignRule rule, DesignEntityResource resource) {
                return rule.analyzeMetaDataAggregate(resource);
            }
        });
        entityHandlers.put("pacdialog", new DesignEntityHandler(){

            @Override
            public RadicalElement getRadicalElement(DesignEntityResource resource) {
                return this.getModelService().getDialog(resource.getProjectName(), resource.getPackageName(), resource.getEntityName());
            }

            @Override
            public boolean analyze(AbstractDesignRule rule, DesignEntityResource resource) {
                return rule.analyzeDialog(resource);
            }
        });
        entityHandlers.put("pacdialogserver", new DesignEntityHandler(){

            @Override
            public RadicalElement getRadicalElement(DesignEntityResource resource) {
                return this.getModelService().getDialogServer(resource.getProjectName(), resource.getPackageName(), resource.getEntityName());
            }

            @Override
            public boolean analyze(AbstractDesignRule rule, DesignEntityResource resource) {
                return rule.analyzeDialogServer(resource);
            }
        });
        entityHandlers.put("paclibrary", new DesignEntityHandler(){

            @Override
            public RadicalElement getRadicalElement(DesignEntityResource resource) {
                return this.getModelService().getLibrary(resource.getProjectName(), resource.getPackageName(), resource.getEntityName());
            }

            @Override
            public boolean analyze(AbstractDesignRule rule, DesignEntityResource resource) {
                return rule.analyzeLibrary(resource);
            }
        });
        entityHandlers.put("pacmacro", new DesignEntityHandler(){

            @Override
            public RadicalElement getRadicalElement(DesignEntityResource resource) {
                return this.getModelService().getMacro(resource.getProjectName(), resource.getPackageName(), resource.getEntityName());
            }

            @Override
            public boolean analyze(AbstractDesignRule rule, DesignEntityResource resource) {
                return rule.analyzeMacro(resource);
            }
        });
        entityHandlers.put("pacprogram", new DesignEntityHandler(){

            @Override
            public RadicalElement getRadicalElement(DesignEntityResource resource) {
                return this.getModelService().getProgram(resource.getProjectName(), resource.getPackageName(), resource.getEntityName());
            }

            @Override
            public boolean analyze(AbstractDesignRule rule, DesignEntityResource resource) {
                return rule.analyzeProgram(resource);
            }
        });
        entityHandlers.put("pacreport", new DesignEntityHandler(){

            @Override
            public RadicalElement getRadicalElement(DesignEntityResource resource) {
                return this.getModelService().getReport(resource.getProjectName(), resource.getPackageName(), resource.getEntityName());
            }

            @Override
            public boolean analyze(AbstractDesignRule rule, DesignEntityResource resource) {
                return rule.analyzeReport(resource);
            }
        });
        entityHandlers.put("pacscreen", new DesignEntityHandler(){

            @Override
            public RadicalElement getRadicalElement(DesignEntityResource resource) {
                return this.getModelService().getScreen(resource.getProjectName(), resource.getPackageName(), resource.getEntityName());
            }

            @Override
            public boolean analyze(AbstractDesignRule rule, DesignEntityResource resource) {
                return rule.analyzeScreen(resource);
            }
        });
        entityHandlers.put("pacserver", new DesignEntityHandler(){

            @Override
            public RadicalElement getRadicalElement(DesignEntityResource resource) {
                return this.getModelService().getServer(resource.getProjectName(), resource.getPackageName(), resource.getEntityName());
            }

            @Override
            public boolean analyze(AbstractDesignRule rule, DesignEntityResource resource) {
                return rule.analyzeServer(resource);
            }
        });
        entityHandlers.put("pactext", new DesignEntityHandler(){

            @Override
            public RadicalElement getRadicalElement(DesignEntityResource resource) {
                return this.getModelService().getText(resource.getProjectName(), resource.getPackageName(), resource.getEntityName());
            }

            @Override
            public boolean analyze(AbstractDesignRule rule, DesignEntityResource resource) {
                return rule.analyzeText(resource);
            }
        });
        entityHandlers.put("pacblockbase", new DesignEntityHandler(){

            @Override
            public RadicalElement getRadicalElement(DesignEntityResource resource) {
                RelationalBlockBase foundElement = this.getModelService().getRelationalBlockBase(resource.getProjectName(), resource.getPackageName(), resource.getEntityName());
                if (foundElement != null) {
                    return foundElement;
                }
                foundElement = this.getModelService().getCodasylBlockBase(resource.getProjectName(), resource.getPackageName(), resource.getEntityName());
                if (foundElement != null) {
                    return foundElement;
                }
                foundElement = this.getModelService().getSocrateBlockBase(resource.getProjectName(), resource.getPackageName(), resource.getEntityName());
                if (foundElement != null) {
                    return foundElement;
                }
                return this.getModelService().getHierarchicalBlockBase(resource.getProjectName(), resource.getPackageName(), resource.getEntityName());
            }

            @Override
            public boolean analyze(AbstractDesignRule rule, DesignEntityResource resource) {
                RadicalElement radical = resource.getRadicalElement();
                if (radical instanceof RelationalBlockBase) {
                    return rule.analyzeRelationalBlockBase(resource);
                }
                if (radical instanceof CodasylBlockBase) {
                    return rule.analyzeCodasylBlockBase(resource);
                }
                if (radical instanceof SocrateBlockBase) {
                    return rule.analyzeSocrateBlockBase(resource);
                }
                if (radical instanceof HierarchicalBlockBase) {
                    return rule.analyzeHierarchicalBlockBase(resource);
                }
                return true;
            }
        });
        entityHandlers.put("paccopybook", new DesignEntityHandler(){

            @Override
            public RadicalElement getRadicalElement(DesignEntityResource resource) {
                return this.getModelService().getCopybook(resource.getProjectName(), resource.getPackageName(), resource.getEntityName());
            }

            @Override
            public boolean analyze(AbstractDesignRule rule, DesignEntityResource resource) {
                return rule.analyzePacCopybook(resource);
            }
        });
        entityHandlers.put("paccommunicationmonitor", new DesignEntityHandler(){

            @Override
            public RadicalElement getRadicalElement(DesignEntityResource resource) {
                return this.getModelService().getCommunicationMonitor(resource.getProjectName(), resource.getPackageName(), resource.getEntityName());
            }

            @Override
            public boolean analyze(AbstractDesignRule rule, DesignEntityResource resource) {
                return rule.analyzeCommunicationMonitor(resource);
            }
        });
        entityHandlers.put("pacdialogcommunicationmonitor", new DesignEntityHandler(){

            @Override
            public RadicalElement getRadicalElement(DesignEntityResource resource) {
                return this.getModelService().getDialogCommunicationMonitor(resource.getProjectName(), resource.getPackageName(), resource.getEntityName());
            }

            @Override
            public boolean analyze(AbstractDesignRule rule, DesignEntityResource resource) {
                return rule.analyzeDialogCommunicationMonitor(resource);
            }
        });
        entityHandlers.put("pacerrorlabel", new DesignEntityHandler(){

            @Override
            public RadicalElement getRadicalElement(DesignEntityResource resource) {
                return this.getModelService().getErrorLabel(resource.getProjectName(), resource.getPackageName(), resource.getEntityName());
            }

            @Override
            public boolean analyze(AbstractDesignRule rule, DesignEntityResource resource) {
                return rule.analyzeErrorLabel(resource);
            }
        });
        entityHandlers.put("pacdialogfolder", new DesignEntityHandler(){

            @Override
            public RadicalElement getRadicalElement(DesignEntityResource resource) {
                return this.getModelService().getDialogFolder(resource.getProjectName(), resource.getPackageName(), resource.getEntityName());
            }

            @Override
            public boolean analyze(AbstractDesignRule rule, DesignEntityResource resource) {
                return rule.analyzeDialogFolder(resource);
            }
        });
        entityHandlers.put("pacdialogfolderview", new DesignEntityHandler(){

            @Override
            public RadicalElement getRadicalElement(DesignEntityResource resource) {
                return this.getModelService().getDialogFolderView(resource.getProjectName(), resource.getPackageName(), resource.getEntityName());
            }

            @Override
            public boolean analyze(AbstractDesignRule rule, DesignEntityResource resource) {
                return rule.analyzeDialogFolderView(resource);
            }
        });
        entityHandlers.put("pacfolderview", new DesignEntityHandler(){

            @Override
            public RadicalElement getRadicalElement(DesignEntityResource resource) {
                return this.getModelService().getFolderView(resource.getProjectName(), resource.getPackageName(), resource.getEntityName());
            }

            @Override
            public boolean analyze(AbstractDesignRule rule, DesignEntityResource resource) {
                return rule.analyzeFolderView(resource);
            }
        });
        entityHandlers.put("pacfolder", new DesignEntityHandler(){

            @Override
            public RadicalElement getRadicalElement(DesignEntityResource resource) {
                return this.getModelService().getFolder(resource.getProjectName(), resource.getPackageName(), resource.getEntityName());
            }

            @Override
            public boolean analyze(AbstractDesignRule rule, DesignEntityResource resource) {
                return rule.analyzeFolder(resource);
            }
        });
        entityHandlers.put("pacinputaid", new DesignEntityHandler(){

            @Override
            public RadicalElement getRadicalElement(DesignEntityResource resource) {
                return this.getModelService().getInputAid(resource.getProjectName(), resource.getPackageName(), resource.getEntityName());
            }

            @Override
            public boolean analyze(AbstractDesignRule rule, DesignEntityResource resource) {
                return rule.analyzeInputAid(resource);
            }
        });
        entityHandlers.put("pacvolume", new DesignEntityHandler(){

            @Override
            public RadicalElement getRadicalElement(DesignEntityResource resource) {
                return this.getModelService().getVolume(resource.getProjectName(), resource.getPackageName(), resource.getEntityName());
            }

            @Override
            public boolean analyze(AbstractDesignRule rule, DesignEntityResource resource) {
                return rule.analyzeVolume(resource);
            }
        });
    }

    public DesignEntityResource(IResource resourceValue) {
        this.resource = resourceValue;
    }

    public IResource getResource() {
        return this.resource;
    }

    public String getProjectName() {
        int relativeSegment = this.resource.getProjectRelativePath().segmentCount();
        IPath fullPath = this.resource.getLocation();
        String projetName = fullPath.segment(fullPath.segmentCount() - relativeSegment - 1);
        return projetName;
    }

    public String getEntityName() {
        int extensionLength = this.getExtension().length();
        String nameWithExtension = this.resource.getName();
        if (extensionLength == 0 && !nameWithExtension.endsWith(".")) {
            extensionLength = 1;
        }
        String name = nameWithExtension.substring(0, nameWithExtension.length() - extensionLength - 1);
        if (nameWithExtension.endsWith("userentity")) {
            return name.substring(0, name.lastIndexOf(46));
        }
        return name;
    }

    public String getMetaType() {
        int extensionLength = this.getExtension().length();
        String nameWithExtension = this.resource.getName();
        if (nameWithExtension.endsWith("userentity")) {
            if (extensionLength == 0 && !nameWithExtension.endsWith(".")) {
                extensionLength = 1;
            }
            String name = nameWithExtension.substring(0, nameWithExtension.length() - extensionLength - 1);
            return name.substring(name.lastIndexOf(46) + 1);
        }
        return null;
    }

    public String getExtension() {
        if (this.extension == null) {
            this.extension = this.resource.getFileExtension();
        }
        return this.extension;
    }

    public String getPackageName() {
        int segmentCount;
        IPath packagePath = this.resource.getProjectRelativePath().removeLastSegments(1);
        String designFolder = PdpPathService.getRppRootFolder((String)this.getProjectName());
        if (designFolder != null && designFolder.length() > 0) {
            packagePath = packagePath.removeFirstSegments(1);
        }
        if ((segmentCount = packagePath.segmentCount()) == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int s = 0;
        while (s < segmentCount - 1) {
            builder.append(packagePath.segment(s)).append('.');
            ++s;
        }
        builder.append(packagePath.segment(segmentCount - 1));
        return builder.toString();
    }

    protected DesignEntityHandler getHandler() {
        if (this.entityHandler == null) {
            this.entityHandler = entityHandlers.get(this.getExtension());
        }
        return this.entityHandler;
    }

    public RadicalElement getRadicalElement() {
        if (this.designEntity == null) {
            try {
                this.designEntity = this.getHandler().getRadicalElement(this);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
        return this.designEntity;
    }

    public StandardSegment getSegment() {
        try {
            return (StandardSegment)this.getRadicalElement();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public MonoStructureSegment getMonoStructureSegment() {
        try {
            return (MonoStructureSegment)this.getRadicalElement();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public LogicalView getLogicalViewSegment() {
        try {
            return (LogicalView)this.getRadicalElement();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public Table getTableSegment() {
        try {
            return (Table)this.getRadicalElement();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public DataElement getDataElement() {
        try {
            return (DataElement)this.getRadicalElement();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public DataStructure getDataStructure() {
        try {
            return (DataStructure)this.getRadicalElement();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public MetaEntity getMetaEntity() {
        try {
            return (MetaEntity)this.getRadicalElement();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public Dialog getDialog() {
        try {
            return (Dialog)this.getRadicalElement();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public DialogServer getDialogServer() {
        try {
            return (DialogServer)this.getRadicalElement();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public DialogFolder getDialogFolder() {
        try {
            return (DialogFolder)this.getRadicalElement();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public Folder getFolder() {
        try {
            return (Folder)this.getRadicalElement();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public DialogFolderView getDialogFolderView() {
        try {
            return (DialogFolderView)this.getRadicalElement();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public FolderView getFolderView() {
        try {
            return (FolderView)this.getRadicalElement();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public CommunicationMonitor getCommunicationMonitor() {
        try {
            return (CommunicationMonitor)this.getRadicalElement();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public DialogCommunicationMonitor getDialogCommunicationMonitor() {
        try {
            return (DialogCommunicationMonitor)this.getRadicalElement();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public Library getLibrary() {
        try {
            return (Library)this.getRadicalElement();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public Macro getMacro() {
        try {
            return (Macro)this.getRadicalElement();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public Program getProgram() {
        try {
            return (Program)this.getRadicalElement();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public Report getReport() {
        try {
            return (Report)this.getRadicalElement();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public Screen getScreen() {
        try {
            return (Screen)this.getRadicalElement();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public Server getServer() {
        try {
            return (Server)this.getRadicalElement();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public Text getText() {
        try {
            return (Text)this.getRadicalElement();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public RelationalBlockBase getRelationalBlockBase() {
        try {
            return (RelationalBlockBase)this.getRadicalElement();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public CodasylBlockBase getCodasylBlockBase() {
        try {
            return (CodasylBlockBase)this.getRadicalElement();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public SocrateBlockBase getSocrateBlockBase() {
        try {
            return (SocrateBlockBase)this.getRadicalElement();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public HierarchicalBlockBase getHierarchicalBlockBase() {
        try {
            return (HierarchicalBlockBase)this.getRadicalElement();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public Copybook getCopybook() {
        try {
            return (Copybook)this.getRadicalElement();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    protected static abstract class DesignEntityHandler {
        public abstract RadicalElement getRadicalElement(DesignEntityResource var1);

        public abstract boolean analyze(AbstractDesignRule var1, DesignEntityResource var2);

        protected IMAFModelService getModelService() {
            return MAFModelService.getInstance();
        }
    }
}

