/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.qualitycontrol.design.provider;

import com.ibm.pdp.qualitycontrol.design.provider.DesignEntityResource;
import com.ibm.rsaz.analysis.core.category.DefaultAnalysisCategory;
import com.ibm.rsaz.analysis.core.data.AnalysisDataCollectorsManager;
import com.ibm.rsaz.analysis.core.data.DataCollector;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.provider.AbstractAnalysisProvider;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;

public class DesignEntityCodeReviewProvider
extends AbstractAnalysisProvider {
    public static final String DEFINED_ID = "com.ibm.pdp.qualitycontrol.design.provider.collector";
    public static final String RESOURCE_PROPERTY = "DesignEntityResource";
    private static final int PROGRESS_SCALE = 10;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2011. All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void analyze(IProgressMonitor monitor, AnalysisHistory history) {
        try {
            DataCollector artifactDataCollector = AnalysisDataCollectorsManager.getDataCollector((String)DEFINED_ID);
            List resources = (List)artifactDataCollector.getAnalysisData();
            if (monitor.isCanceled()) {
                return;
            }
            history.setAnalyzedResources(resources);
            Collection selectedCategories = this.getSelectedCategories(history);
            monitor.beginTask(this.getLabel(), resources.size() * selectedCategories.size() * 10);
            if (monitor.isCanceled()) {
                return;
            }
            for (IResource resource : resources) {
                DesignEntityResource designEntityResource = new DesignEntityResource(resource);
                this.setProperty(history.getHistoryId(), RESOURCE_PROPERTY, designEntityResource);
                monitor.subTask(designEntityResource.getResource().getName());
                for (DefaultAnalysisCategory category : selectedCategories) {
                    try {
                        category.analyze(history, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        monitor.done();
                        this.removeProperty(history.getHistoryId(), RESOURCE_PROPERTY);
                        this.tearDown();
                        return;
                    }
                    if (!monitor.isCanceled()) continue;
                    return;
                }
                monitor.worked(10);
                if (!monitor.isCanceled()) continue;
                return;
            }
        }
        finally {
            monitor.done();
            this.removeProperty(history.getHistoryId(), RESOURCE_PROPERTY);
            this.tearDown();
        }
    }
}

