/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.qualitycontrol.design.provider;

import com.ibm.pdp.qualitycontrol.design.provider.DesignEntityResource;
import com.ibm.rsaz.analysis.core.element.AbstractAnalysisElement;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.reporting.tabulatedmodel.AbstractTabulatedAnalysisResult;
import com.ibm.rsaz.analysis.core.reporting.tabulatedmodel.SingleFileTabulatedAnalysisResult;
import com.ibm.rsaz.analysis.core.result.AbstractAnalysisResult;
import com.ibm.rsaz.analysis.core.result.BasicCodeReviewResult;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import org.eclipse.core.resources.IResource;

public abstract class AbstractDesignRule
extends AbstractAnalysisRule {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void analyze(AnalysisHistory history) {
        String historyId = history.getHistoryId();
        DesignEntityResource designEntityResource = (DesignEntityResource)this.getProvider().getProperty(historyId, "DesignEntityResource");
        if (designEntityResource != null && !this.analyzeResource(designEntityResource)) {
            this.declareViolation(history, designEntityResource);
        }
    }

    public abstract boolean analyzeResource(DesignEntityResource var1);

    protected boolean analyzeSpecificType(DesignEntityResource resource) {
        return resource.getHandler().analyze(this, resource);
    }

    protected boolean analyzeSegment(DesignEntityResource resource) {
        return true;
    }

    protected boolean analyzeMonoStructureSegment(DesignEntityResource resource) {
        return true;
    }

    protected boolean analyzeLogicalViewSegment(DesignEntityResource resource) {
        return true;
    }

    protected boolean analyzeTableSegment(DesignEntityResource resource) {
        return true;
    }

    protected boolean analyzeDataElement(DesignEntityResource resource) {
        return true;
    }

    protected boolean analyzeDataStructure(DesignEntityResource resource) {
        return true;
    }

    protected boolean analyzeMetaEntity(DesignEntityResource resource) {
        return true;
    }

    protected boolean analyzeMetaEntityType(DesignEntityResource resource) {
        return true;
    }

    protected boolean analyzeUserEntity(DesignEntityResource resource) {
        return true;
    }

    protected boolean analyzeMetaDataAggregate(DesignEntityResource resource) {
        return true;
    }

    protected boolean analyzeDialog(DesignEntityResource resource) {
        return true;
    }

    protected boolean analyzeDialogServer(DesignEntityResource resource) {
        return true;
    }

    protected boolean analyzeLibrary(DesignEntityResource resource) {
        return true;
    }

    protected boolean analyzeMacro(DesignEntityResource resource) {
        return true;
    }

    protected boolean analyzeProgram(DesignEntityResource resource) {
        return true;
    }

    protected boolean analyzeReport(DesignEntityResource resource) {
        return true;
    }

    protected boolean analyzeScreen(DesignEntityResource resource) {
        return true;
    }

    protected boolean analyzeServer(DesignEntityResource resource) {
        return true;
    }

    protected boolean analyzeText(DesignEntityResource resource) {
        return true;
    }

    protected boolean analyzeRelationalBlockBase(DesignEntityResource resource) {
        return true;
    }

    protected boolean analyzeCodasylBlockBase(DesignEntityResource resource) {
        return true;
    }

    protected boolean analyzeSocrateBlockBase(DesignEntityResource resource) {
        return true;
    }

    protected boolean analyzeHierarchicalBlockBase(DesignEntityResource resource) {
        return true;
    }

    protected boolean analyzePacCopybook(DesignEntityResource resource) {
        return true;
    }

    protected boolean analyzeCommunicationMonitor(DesignEntityResource resource) {
        return true;
    }

    protected boolean analyzeDialogCommunicationMonitor(DesignEntityResource resource) {
        return true;
    }

    protected boolean analyzeErrorLabel(DesignEntityResource resource) {
        return true;
    }

    protected boolean analyzeDialogFolder(DesignEntityResource resource) {
        return true;
    }

    protected boolean analyzeDialogFolderView(DesignEntityResource resource) {
        return true;
    }

    protected boolean analyzeFolderView(DesignEntityResource resource) {
        return true;
    }

    protected boolean analyzeFolder(DesignEntityResource resource) {
        return true;
    }

    protected boolean analyzeInputAid(DesignEntityResource resource) {
        return true;
    }

    protected boolean analyzeVolume(DesignEntityResource resource) {
        return true;
    }

    protected void declareViolation(AnalysisHistory history, DesignEntityResource designEntityResource) {
        String historyId = history.getHistoryId();
        IResource resource = designEntityResource.getResource();
        Object result = null;
        String extraLabel = this.getExtraLabel();
        result = extraLabel == null || extraLabel.length() == 0 ? new BasicCodeReviewResult(resource.getFullPath().toString(), 0, 0, 0, resource, (AbstractAnalysisRule)this, history.getHistoryId(), true) : new CodeReviewResultWithCustomLabel(extraLabel, resource.getFullPath().toString(), 0, 0, 0, resource, this, history.getHistoryId());
        result.setRuleSpecificResult((Object)this.getExtraLabel());
        this.addHistoryResultSet(historyId, (AbstractAnalysisResult)result);
    }

    protected String getExtraLabel() {
        return "";
    }

    public class CodeReviewResultWithCustomLabel
    extends BasicCodeReviewResult {
        private String _rppExtraLabel;
        private int _lineNumber;
        public static final String _CR = "\n";

        public CodeReviewResultWithCustomLabel(String label, String resName, int lineNumber, int selectionStartPos, int selectionLength, IResource resource, AbstractAnalysisRule rule, String historyId) {
            super(resName, lineNumber, selectionStartPos, selectionLength, resource, rule, historyId, true);
            this._rppExtraLabel = label;
            this._lineNumber = label.indexOf("[") != -1 ? 0 : (label.indexOf(" ") != -1 ? Integer.parseInt(label.trim()) : lineNumber);
            this.setOwner((AbstractAnalysisElement)rule);
        }

        public int getLineNumber() {
            return this._lineNumber;
        }

        public String getResourceName() {
            if (this._lineNumber == 0) {
                return super.getResourceName() + " " + this._rppExtraLabel;
            }
            return super.getResourceName();
        }

        public String getLabel() {
            StringBuffer sb = new StringBuffer(this.getResource().getName());
            sb.append(' ').append(this.getLabelWithVariables()).append(' ').append(':').append(' ').append(this._rppExtraLabel);
            return sb.toString();
        }

        public AbstractTabulatedAnalysisResult tabulate() {
            StringBuilder sb = new StringBuilder(this.getResourceName());
            sb.append(this._rppExtraLabel);
            return new PDPSingleFileTabulatedAnalysisResult(sb.toString(), 0, this.isVisible(), this._rppExtraLabel);
        }
    }

    public class PDPSingleFileTabulatedAnalysisResult
    extends SingleFileTabulatedAnalysisResult {
        private String extra;

        public PDPSingleFileTabulatedAnalysisResult(String file, int line, boolean visible, String extra) {
            super(file, line, visible);
            this.extra = extra;
        }

        public String getExtra() {
            return this.extra;
        }
    }
}

