/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.qualitycontrol.cobol.rules.template;

import com.ibm.pdp.qualitycontrol.cobol.provider.AbstractRppCobolRule;
import com.ibm.systemz.cobol.editor.core.parser.Ast.ASTNode;
import com.ibm.systemz.cobol.editor.core.parser.Ast.AbstractVisitor;
import com.ibm.systemz.cobol.editor.core.parser.Ast.CallStatementPrefix0;
import com.ibm.systemz.cobol.editor.core.parser.Ast.IStringLiteral;
import com.ibm.systemz.cobol.editor.core.parser.Ast.IStringLiteralLineContinuation;
import com.ibm.systemz.cobol.editor.core.parser.Ast.StringLiteral0;
import com.ibm.systemz.cobol.editor.core.parser.Ast.StringLiteral1;
import com.ibm.systemz.cobol.editor.core.parser.Ast.StringLiteral2;
import com.ibm.systemz.cobol.editor.core.parser.Ast.StringLiteral3;
import com.ibm.systemz.cobol.editor.core.parser.Ast.StringLiteral4;
import com.ibm.systemz.cobol.editor.core.parser.Ast.StringLiteral5;
import com.ibm.systemz.cobol.editor.core.parser.Ast.StringLiteral6;
import com.ibm.systemz.cobol.editor.core.parser.Ast.StringLiteralLineContinuation0;
import com.ibm.systemz.cobol.editor.core.parser.Ast.StringLiteralLineContinuation1;
import java.util.ArrayList;
import java.util.List;
import lpg.runtime.IAst;
import lpg.runtime.IAstVisitor;

public class StaticCallNameRule
extends AbstractRppCobolRule {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public List<IAst> performRule(ASTNode baseNode) {
        final ArrayList<IAst> tokens = new ArrayList<IAst>();
        final String PROGRAM_NAME = this.getParameter("PROGRAM_NAME").getValue();
        baseNode.accept((IAstVisitor)new AbstractVisitor(){

            public void unimplementedVisitor(String arg0) {
            }

            public boolean visit(CallStatementPrefix0 n) {
                String value;
                if (n.getIdentifierLiteral() instanceof IStringLiteral && !PROGRAM_NAME.equalsIgnoreCase(value = StaticCallNameRule.GetStringLiteralValue((IStringLiteral)n.getIdentifierLiteral()))) {
                    tokens.add((IAst)n.getIdentifierLiteral());
                }
                return true;
            }
        });
        return tokens;
    }

    public static String GetStringLiteralValue(IStringLiteral stringLiteral) {
        Object value = null;
        String token = null;
        if (stringLiteral instanceof StringLiteral0) {
            StringLiteral0 lit = (StringLiteral0)stringLiteral;
            token = lit.getSTRING_LITERAL().toString();
            value = StaticCallNameRule.CollapseQuotes(token);
        } else if (stringLiteral instanceof StringLiteral1) {
            StringLiteral1 lit = (StringLiteral1)stringLiteral;
            token = lit.getHEX_STRING_LITERAL().toString();
            value = StaticCallNameRule.CollapseQuotes(token);
        } else if (stringLiteral instanceof StringLiteral2) {
            StringLiteral2 lit = (StringLiteral2)stringLiteral;
            token = lit.getDBCS_STRING_LITERAL().toString();
            value = StaticCallNameRule.CollapseQuotes(token);
        } else if (stringLiteral instanceof StringLiteral3) {
            StringLiteral3 lit = (StringLiteral3)stringLiteral;
            token = lit.getNULL_TERMINATED_STRING_LITERAL().toString();
            value = StaticCallNameRule.CollapseQuotes(token);
        } else if (stringLiteral instanceof StringLiteral4) {
            StringLiteral4 lit = (StringLiteral4)stringLiteral;
            token = lit.getNATIONAL_STRING_LITERAL().toString();
            value = StaticCallNameRule.CollapseQuotes(token);
        } else if (stringLiteral instanceof StringLiteral5) {
            StringLiteral5 lit = (StringLiteral5)stringLiteral;
            token = lit.getNATIONAL_HEX_STRING_LITERAL().toString();
            value = StaticCallNameRule.CollapseQuotes(token);
        } else if (stringLiteral instanceof StringLiteral6) {
            StringLiteral6 lit = (StringLiteral6)stringLiteral;
            IStringLiteralLineContinuation cont = lit.getStringLiteralLineContinuation();
            String continuation = StaticCallNameRule.GetStringLiteralValue(cont);
            token = lit.getSTRING_LITERAL().toString();
            value = continuation + StaticCallNameRule.CollapseQuotes(token);
        }
        return value;
    }

    private static String GetStringLiteralValue(IStringLiteralLineContinuation cont) {
        Object value = new String();
        if (cont instanceof StringLiteralLineContinuation0) {
            value = StaticCallNameRule.CollapseQuotes(((StringLiteralLineContinuation0)cont).getSTRING_LITERAL_CONTINUATION().toString());
        } else if (cont instanceof StringLiteralLineContinuation1) {
            value = StaticCallNameRule.GetStringLiteralValue(((StringLiteralLineContinuation1)cont).getStringLiteralLineContinuation());
            value = (String)value + StaticCallNameRule.CollapseQuotes(((StringLiteralLineContinuation1)cont).getSTRING_LITERAL_CONTINUATION().toString());
        }
        return value;
    }

    private static String CollapseQuotes(String s) {
        Object rc = new String();
        int characterState = 0;
        boolean lastCharWasQuote = false;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (characterState == 0) {
                if (c == '\'') {
                    characterState = 1;
                } else if (c == '\"') {
                    characterState = 2;
                }
            } else if (characterState == 1) {
                if (c == '\'') {
                    if (lastCharWasQuote) {
                        rc = (String)rc + c;
                        lastCharWasQuote = false;
                    } else {
                        lastCharWasQuote = true;
                    }
                } else {
                    if (lastCharWasQuote) break;
                    rc = (String)rc + c;
                }
            } else if (characterState == 2) {
                if (c == '\"') {
                    if (lastCharWasQuote) {
                        rc = (String)rc + c;
                        lastCharWasQuote = false;
                    } else {
                        lastCharWasQuote = true;
                    }
                } else {
                    if (lastCharWasQuote) break;
                    rc = (String)rc + c;
                }
            }
            ++i;
        }
        return rc;
    }
}

