/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.qualitycontrol.cobol.rules.template;

import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.qualitycontrol.cobol.provider.PDPCodeReviewProvider;
import com.ibm.pdp.qualitycontrol.cobol.rules.template.AbstractRppCobolRuleTemplateWithThresholds;
import com.ibm.pdp.qualitycontrol.collector.PdpCobolData;
import com.ibm.rsar.analysis.codereview.cobol.rules.SqlAvoidSelectStar;
import com.ibm.systemz.cobol.editor.core.parser.Ast.ASTNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import lpg.runtime.IAst;

public class SqlAvoidSelectStarInWorking
extends AbstractRppCobolRuleTemplateWithThresholds {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2016. All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public List<IAst> performRule(ASTNode baseNode) {
        SqlAvoidSelectStar rule = new SqlAvoidSelectStar();
        List<IAst> asts = rule.performRule(baseNode);
        PdpCobolData pdpCobolData = ((PDPCodeReviewProvider)this.getProvider()).getPdpCobolData(this.getHistoryId());
        if (pdpCobolData == null) {
            return asts;
        }
        asts = this.removeAuthorizedSelectStar(asts, pdpCobolData.getEditTree());
        this.filterResults(asts);
        if (!this.checkEntityLines(asts.size())) {
            return asts;
        }
        return new ArrayList<IAst>();
    }

    private List<IAst> removeAuthorizedSelectStar(List<IAst> asts, IEditTree editTree) {
        Iterator<IAst> iterator = asts.iterator();
        while (iterator.hasNext()) {
            int endIdx;
            IAst node = iterator.next();
            int beginIdx = node.getLeftIToken().getStartOffset();
            ITextNode textNode = editTree.includingNode(beginIdx, endIdx = node.getRightIToken().getEndOffset());
            if (this.isWorkingStorage(textNode)) continue;
            iterator.remove();
        }
        return asts;
    }

    private boolean isWorkingStorage(ITextNode node) {
        String tagname = node.enclosingTagName();
        if (tagname.equals("DATA")) {
            return true;
        }
        ITextNode parentNode = node.parentNode();
        if (parentNode == null) {
            return false;
        }
        return this.isWorkingStorage(parentNode);
    }
}

