/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.qualitycontrol.cobol.rules.template;

import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.qualitycontrol.cobol.provider.AbstractRppCobolRuleWithoutDeviation;
import com.ibm.pdp.qualitycontrol.cobol.provider.PDPCodeReviewProvider;
import com.ibm.pdp.qualitycontrol.cobol.rules.SyncPointRule;
import com.ibm.pdp.qualitycontrol.collector.PdpCobolData;
import com.ibm.rsar.analysis.codereview.cobol.CodeReviewResource;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.systemz.cobol.editor.core.parser.Ast.ASTNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import lpg.runtime.IAst;

public class RppSyncPointInMacroRule
extends AbstractRppCobolRuleWithoutDeviation {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String[] macros;
    private static final String SPLITPATTERN = "[,\\s]+";

    public void preAnalyze(AnalysisHistory history) {
        super.preAnalyze(history);
        this.macros = this.getParam("macros");
    }

    public void analyze(AnalysisHistory analysisHistory) {
        String historyId = analysisHistory.getHistoryId();
        CodeReviewResource rdzData = (CodeReviewResource)this.getProvider().getProperty(historyId, "rpp.codereview.cobol.resource");
        if (rdzData == null) {
            return;
        }
        ASTNode node = (ASTNode)rdzData.getCompilationUnit();
        if (node == null) {
            return;
        }
        List<IAst> results = new SyncPointRule().performRule(node);
        if (results.isEmpty()) {
            return;
        }
        PdpCobolData pdpCobolData = ((PDPCodeReviewProvider)this.getProvider()).getPdpCobolData(historyId);
        this.removeAuthorizedCallStatement(results, pdpCobolData.getEditTree());
        if (results.isEmpty()) {
            return;
        }
        this.addResult(pdpCobolData.getResource(), historyId, results);
    }

    private void removeAuthorizedCallStatement(List<IAst> asts, IEditTree editTree) {
        Iterator<IAst> iterator = asts.iterator();
        while (iterator.hasNext()) {
            IAst node = iterator.next();
            ITextNode textNode = editTree.includingNode(node.getLeftIToken().getStartOffset(), node.getRightIToken().getEndOffset());
            if (this.checkAllowedNodes(textNode)) continue;
            iterator.remove();
        }
    }

    private boolean checkAllowedNodes(ITextNode textNode) {
        IGeneratedTag generatedTag = textNode.enclosingGeneratedTag();
        if (generatedTag != null && generatedTag.getProperty("msp") != null) {
            String macroName = generatedTag.getProperty("msp");
            return !this.isContainMacro(macroName);
        }
        ITextNode parentNode = textNode.parentNode();
        if (parentNode == null) {
            return false;
        }
        return this.checkAllowedNodes(parentNode);
    }

    private boolean isContainMacro(String macroName) {
        String[] stringArray = this.macros;
        int n = this.macros.length;
        int n2 = 0;
        while (n2 < n) {
            String macro = stringArray[n2];
            if (macroName.equals(macro)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected String[] getParameters(String param) {
        return param.replaceFirst("^[,\\s]+", "").split(SPLITPATTERN, 0);
    }

    protected String[] getParam(String input) {
        String param = this.getParameter(input).getValue();
        return this.getParameters(param);
    }

    public List<IAst> performRule(ASTNode baseNode) {
        return null;
    }

    public String getExtraLabel() {
        ArrayList<String> stringList = new ArrayList<String>(Arrays.asList(this.macros));
        return ((Object)stringList).toString();
    }
}

