/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.qualitycontrol.cobol.rules.template;

import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.qualitycontrol.cobol.provider.PDPCodeReviewProvider;
import com.ibm.pdp.qualitycontrol.cobol.rules.CicsLinkStatementRule;
import com.ibm.pdp.qualitycontrol.cobol.rules.template.AbstractCobolRuleTemplate;
import com.ibm.pdp.qualitycontrol.collector.PdpCobolData;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.systemz.cobol.editor.core.parser.Ast.ASTNode;
import java.util.Iterator;
import java.util.List;
import lpg.runtime.IAst;

public class RppCicsLinkStatementFunctionRule
extends AbstractCobolRuleTemplate {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void preAnalyze(AnalysisHistory history) {
        super.preAnalyze(history);
        this.functions = this.getParam("functions");
    }

    public List<IAst> performRule(ASTNode baseNode) {
        List<IAst> asts = new CicsLinkStatementRule().performRule(baseNode);
        PdpCobolData pdpCobolData = ((PDPCodeReviewProvider)this.getProvider()).getPdpCobolData(this.getHistoryId());
        if (pdpCobolData == null) {
            return asts;
        }
        return this.removeAuthorizedLink(asts, pdpCobolData.getEditTree());
    }

    private List<IAst> removeAuthorizedLink(List<IAst> asts, IEditTree editTree) {
        Iterator<IAst> iterator = asts.iterator();
        while (iterator.hasNext()) {
            int endIdx;
            IAst node = iterator.next();
            int beginIdx = node.getLeftIToken().getStartOffset();
            ITextNode textNode = editTree.includingNode(beginIdx, endIdx = node.getRightIToken().getEndOffset());
            if (!this.checkAllowedNodes(textNode)) continue;
            iterator.remove();
        }
        return asts;
    }

    private boolean checkAllowedNodes(ITextNode textNode) {
        String tagname = textNode.enclosingTagName();
        String[] stringArray = this.functions;
        int n = this.functions.length;
        int n2 = 0;
        while (n2 < n) {
            String function = stringArray[n2];
            if (tagname.startsWith(function)) {
                return true;
            }
            ++n2;
        }
        ITextNode parentNode = textNode.parentNode();
        if (parentNode == null) {
            return false;
        }
        return this.checkAllowedNodes(parentNode);
    }
}

