/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.qualitycontrol.cobol.rules.template;

import com.ibm.pdp.qualitycontrol.cobol.provider.AbstractRppCobolRule;
import com.ibm.pdp.qualitycontrol.cobol.provider.PDPCodeReviewProvider;
import com.ibm.pdp.qualitycontrol.collector.PdpCobolData;
import com.ibm.rsar.analysis.codereview.cobol.CodeReviewResource;
import com.ibm.rsar.analysis.codereview.cobol.CodeReviewResult;
import com.ibm.rsar.analysis.codereview.cobol.rules.NameCollector;
import com.ibm.rsaz.analysis.core.element.AbstractAnalysisElement;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.result.AbstractAnalysisResult;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import com.ibm.systemz.cobol.editor.core.parser.Ast.ASTNode;
import com.ibm.systemz.cobol.editor.core.parser.Ast.AbstractVisitor;
import com.ibm.systemz.cobol.editor.core.parser.Ast.ProcedureDivision0;
import com.ibm.systemz.cobol.editor.core.parser.Ast.ProcedureDivision1;
import java.util.ArrayList;
import java.util.List;
import lpg.runtime.IAst;
import lpg.runtime.IAstVisitor;
import org.eclipse.core.resources.IResource;

public class ProcedureRule
extends AbstractRppCobolRule {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected int beginingLineNumber = -1;
    protected int endingLineNumber = -1;
    protected int beginingIndexPosition = -1;
    protected int endIndexPosition = -1;
    protected int procedureLinesNumber = 0;

    public void analyze(AnalysisHistory history) {
        CodeReviewResource rdzData;
        this.procedureLinesNumber = 0;
        this.historyId = history.getHistoryId();
        this.resource = rdzData = (CodeReviewResource)this.getProvider().getProperty(this.historyId, "rpp.codereview.cobol.resource");
        if (rdzData == null) {
            return;
        }
        ASTNode node = (ASTNode)rdzData.getCompilationUnit();
        if (node == null) {
            return;
        }
        this.fileName = (String)this.getProvider().getProperty(this.historyId, NameCollector.KEYS[0]);
        String historyId = history.getHistoryId();
        PdpCobolData pdpCobolData = ((PDPCodeReviewProvider)this.getProvider()).getPdpCobolData(historyId);
        if (pdpCobolData == null) {
            return;
        }
        List<IAst> results = this.performRule(node);
        if (results == null || results.isEmpty()) {
            return;
        }
        this.getRealLimit();
        if (this.procedureLinesNumber > this.realLimit) {
            this.addResult(pdpCobolData.getResource(), historyId);
        }
    }

    public void addResult(IResource resource, String historyId) {
        Object violation = null;
        String extraLabel = this.getExtraLabel();
        violation = extraLabel == null || extraLabel.length() == 0 ? new CodeReviewResult(resource.getFullPath().toString(), this.beginingLineNumber, this.beginingIndexPosition, this.endIndexPosition - this.beginingIndexPosition, resource, (AbstractAnalysisRule)this, historyId, true) : new AbstractRppCobolRule.CodeReviewResultWithCustomLabel((AbstractRppCobolRule)this, extraLabel, resource.getFullPath().toString(), 0, this.beginingIndexPosition, this.endIndexPosition - this.beginingIndexPosition, resource, (AbstractAnalysisRule)this, historyId);
        violation.setOwner((AbstractAnalysisElement)this);
        this.addHistoryResultSet(historyId, (AbstractAnalysisResult)violation);
    }

    protected String getExtraLabel() {
        return " : " + String.valueOf(this.procedureLinesNumber) + " vs maximum " + String.valueOf(this.realLimit);
    }

    public List<IAst> performRule(ASTNode baseNode) {
        final ArrayList<IAst> tokens = new ArrayList<IAst>();
        baseNode.accept((IAstVisitor)new AbstractVisitor(){

            public void unimplementedVisitor(String s) {
            }

            public boolean visit(ProcedureDivision0 division) {
                int startLine = division.getLeftIToken().getLine();
                int endLine = division.getRightIToken().getLine();
                ProcedureRule.this.beginingLineNumber = startLine;
                ProcedureRule.this.procedureLinesNumber = endLine - startLine;
                ProcedureRule.this.beginingIndexPosition = division.getLeftIToken().getStartOffset();
                ProcedureRule.this.endIndexPosition = division.getRightIToken().getEndOffset();
                if (endLine - startLine > ProcedureRule.this.realLimit) {
                    tokens.add(division.getSections());
                }
                return false;
            }

            public boolean visit(ProcedureDivision1 division) {
                int startLine = division.getLeftIToken().getLine();
                int endLine = division.getRightIToken().getLine();
                ProcedureRule.this.beginingIndexPosition = division.getLeftIToken().getStartOffset();
                ProcedureRule.this.endIndexPosition = division.getRightIToken().getEndOffset();
                ProcedureRule.this.procedureLinesNumber = endLine - startLine;
                ProcedureRule.this.beginingLineNumber = startLine;
                if (endLine - startLine > ProcedureRule.this.realLimit) {
                    tokens.add(division.getParagraphs());
                }
                return false;
            }
        });
        return tokens;
    }
}

