/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.qualitycontrol.cobol.rules.template;

import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.TextStatus;
import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.pacbase.IFunctionNode;
import com.ibm.pdp.pacbase.INodeLoader;
import com.ibm.pdp.pacbase.NodeLoader2;
import com.ibm.pdp.pacbase.dialogcommon.wizards.DialogNodeLoader;
import com.ibm.pdp.pacbase.extension.Ebcdic;
import com.ibm.pdp.qualitycontrol.cobol.provider.AbstractRppCobolRule;
import com.ibm.pdp.qualitycontrol.cobol.provider.PDPCodeReviewProvider;
import com.ibm.pdp.qualitycontrol.cobol.rules.template.AbstractCobolRuleTemplate;
import com.ibm.pdp.qualitycontrol.collector.PdpCobolData;
import com.ibm.rsar.analysis.codereview.cobol.CodeReviewResult;
import com.ibm.rsaz.analysis.core.element.AbstractAnalysisElement;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.result.AbstractAnalysisResult;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import com.ibm.systemz.cobol.editor.core.parser.Ast.ASTNode;
import java.util.List;
import lpg.runtime.IAst;
import org.eclipse.core.resources.IResource;

public class NoSubFunctionInFunctionRule
extends AbstractCobolRuleTemplate {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String beginFunctions;
    private static final String prefixFunction = "F";
    private String endFunctions;
    private int lastViolationLineRank;
    private int lastViolationEndIndex;

    public void preAnalyze(AnalysisHistory history) {
        super.preAnalyze(history);
        this.functions = this.getParam("functions");
        this.beginFunctions = prefixFunction + this.functions[0];
        this.endFunctions = this.beginFunctions;
        if (this.functions.length > 1) {
            this.endFunctions = prefixFunction + this.functions[1];
        }
    }

    public void analyze(AnalysisHistory history) {
        PdpCobolData pdpCobolData;
        String historyId = history.getHistoryId();
        INodeLoader nl = this.getNodeLoader(historyId, pdpCobolData = ((PDPCodeReviewProvider)this.getProvider()).getPdpCobolData(historyId));
        if (nl != null && pdpCobolData != null) {
            IEditTree editTree = pdpCobolData.getEditTree();
            this.lastViolationLineRank = -1;
            this.lastViolationEndIndex = -1;
            int i = 0;
            while (i < nl.getNodesList().size()) {
                IFunctionNode functionNode = (IFunctionNode)nl.getNodesList().get(i);
                if (Ebcdic.stringCompare((String)functionNode.getName(), (String)this.beginFunctions) >= 0 && Ebcdic.stringCompare((String)functionNode.getName(), (String)this.endFunctions) <= 0) {
                    int beginIdx = functionNode.getOffset();
                    int endIdx = functionNode.getEndOffset();
                    ITextNode textNode = editTree.includingNode(beginIdx, endIdx);
                    this.findSubFunctionInto(historyId, pdpCobolData, textNode, beginIdx, endIdx);
                }
                ++i;
            }
        }
    }

    private INodeLoader getNodeLoader(String historyId, PdpCobolData pdpCobolData) {
        String name = pdpCobolData.getDesignFileName();
        if (name != null && name.endsWith("pacscreen")) {
            return new DialogNodeLoader(pdpCobolData.getEditTree());
        }
        return new NodeLoader2(pdpCobolData.getEditTree());
    }

    private void findSubFunctionInto(String historyId, PdpCobolData pdpCobolData, ITextNode node, int beginIdx, int endIdx) {
        IGeneratedTag tag;
        TextStatus status = node.getTextStatus();
        if ((status == TextStatus.Deleted || status == TextStatus.Modified || status == TextStatus.Inserted) && (tag = node.enclosingGeneratedTag()) != null) {
            int lineRank = pdpCobolData.lineRankFromCharIndex(beginIdx);
            this.addResult(pdpCobolData.getResource(), historyId, beginIdx, endIdx, lineRank);
        }
    }

    public void addResult(IResource resource, String historyId, int beginIdx, int endIdx, int lineRank) {
        if (lineRank <= this.lastViolationLineRank || beginIdx < this.lastViolationEndIndex) {
            return;
        }
        this.lastViolationLineRank = lineRank;
        this.lastViolationEndIndex = endIdx;
        Object result = null;
        String extraLabel = this.getExtraLabel();
        result = extraLabel == null || extraLabel.length() == 0 ? new CodeReviewResult(resource.getFullPath().toString(), 1 + lineRank, beginIdx, endIdx - beginIdx, resource, (AbstractAnalysisRule)this, historyId, true) : new AbstractRppCobolRule.CodeReviewResultWithCustomLabel((AbstractRppCobolRule)this, extraLabel, resource.getFullPath().toString(), 1 + lineRank, beginIdx, endIdx - beginIdx, resource, (AbstractAnalysisRule)this, historyId);
        result.setOwner((AbstractAnalysisElement)this);
        this.addHistoryResultSet(historyId, (AbstractAnalysisResult)result);
    }

    public List<IAst> performRule(ASTNode baseNode) {
        return null;
    }
}

