/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.qualitycontrol.cobol.rules.template;

import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.TextStatus;
import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.qualitycontrol.cobol.provider.AbstractRppCobolRule;
import com.ibm.pdp.qualitycontrol.cobol.provider.PDPCodeReviewProvider;
import com.ibm.pdp.qualitycontrol.collector.PdpCobolData;
import com.ibm.rsar.analysis.codereview.cobol.CodeReviewResult;
import com.ibm.rsaz.analysis.core.element.AbstractAnalysisElement;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.result.AbstractAnalysisResult;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import com.ibm.systemz.cobol.editor.core.parser.Ast.ASTNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import lpg.runtime.IAst;
import org.eclipse.core.resources.IResource;

public class NoSpecificInMacroRule
extends AbstractRppCobolRule {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2017, 2021. All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Set<String> _macroStructuresNames;
    private int lastViolationLineRank;
    private int lastViolationEndIndex;
    private static final String SPLITPATTERN = "[,\\s]+";

    public void preAnalyze(AnalysisHistory history) {
        super.preAnalyze(history);
        String[] macroStructuresNames = this.getParam("macros");
        this._macroStructuresNames = new HashSet<String>();
        String[] stringArray = macroStructuresNames;
        int n = macroStructuresNames.length;
        int n2 = 0;
        while (n2 < n) {
            String macroStructureName = stringArray[n2];
            this._macroStructuresNames.add(macroStructureName);
            ++n2;
        }
    }

    public void analyze(AnalysisHistory history) {
        String historyId = history.getHistoryId();
        PdpCobolData pdpCobolData = ((PDPCodeReviewProvider)this.getProvider()).getPdpCobolData(historyId);
        if (pdpCobolData != null) {
            this.findOverwrittenMacroLines(historyId, pdpCobolData);
        }
    }

    private void findOverwrittenMacroLines(String historyId, PdpCobolData pdpCobolData) {
        this.lastViolationLineRank = -1;
        this.lastViolationEndIndex = -1;
        IEditTree editTree = pdpCobolData.getEditTree();
        Iterator rootNodes = editTree.rootNodes();
        while (rootNodes.hasNext()) {
            this.findOverwrittenMacroLinesInto(historyId, pdpCobolData, (ITextNode)rootNodes.next());
        }
    }

    private void findOverwrittenMacroLinesInto(String historyId, PdpCobolData pdpCobolData, ITextNode node) {
        IGeneratedTag tag;
        TextStatus status = node.getTextStatus();
        if ((status == TextStatus.Deleted || status == TextStatus.Modified || status == TextStatus.Inserted) && (tag = node.enclosingGeneratedTag()) != null && tag.getProperty("msp") != null && this._macroStructuresNames.contains(tag.getProperty("msp"))) {
            int beginIdx = node.beginIndex();
            int lineRank = pdpCobolData.lineRankFromCharIndex(beginIdx);
            this.addResult(pdpCobolData.getResource(), historyId, beginIdx, node.endIndex(), lineRank);
        }
        if (node.includeUserSubNode()) {
            Iterator subnodes = node.sons();
            while (subnodes.hasNext()) {
                this.findOverwrittenMacroLinesInto(historyId, pdpCobolData, (ITextNode)subnodes.next());
            }
        }
    }

    private void addResult(IResource resource, String historyId, int beginIdx, int endIdx, int lineRank) {
        if (lineRank > this.lastViolationLineRank || beginIdx > this.lastViolationEndIndex) {
            this.lastViolationLineRank = lineRank;
            this.lastViolationEndIndex = endIdx;
            Object result = null;
            String extraLabel = this.getExtraLabel();
            result = extraLabel == null || extraLabel.length() == 0 ? new CodeReviewResult(resource.getFullPath().toString(), 1 + lineRank, beginIdx, endIdx - beginIdx, resource, (AbstractAnalysisRule)this, historyId, true) : new AbstractRppCobolRule.CodeReviewResultWithCustomLabel((AbstractRppCobolRule)this, extraLabel, resource.getFullPath().toString(), 1 + lineRank, beginIdx, endIdx - beginIdx, resource, (AbstractAnalysisRule)this, historyId);
            result.setOwner((AbstractAnalysisElement)this);
            this.addHistoryResultSet(historyId, (AbstractAnalysisResult)result);
        }
    }

    protected String[] getParameters(String param) {
        return param.replaceFirst("^[,\\s]+", "").split(SPLITPATTERN, 0);
    }

    protected String[] getParam(String input) {
        String param = this.getParameter(input).getValue();
        return this.getParameters(param);
    }

    public List<IAst> performRule(ASTNode baseNode) {
        return null;
    }

    public String getExtraLabel() {
        ArrayList<String> stringList = new ArrayList<String>(this._macroStructuresNames);
        return ((Object)stringList).toString();
    }
}

