/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.qualitycontrol.cobol.rules.template;

import com.ibm.pdp.qualitycontrol.cobol.provider.AbstractRppCobolRuleWithoutDeviation;
import com.ibm.systemz.cobol.editor.core.parser.Ast.ASTNode;
import com.ibm.systemz.cobol.editor.core.parser.Ast.AbstractVisitor;
import com.ibm.systemz.cobol.editor.core.parser.Ast.IfStatement;
import com.ibm.systemz.cobol.editor.core.parser.Ast.StatementList;
import java.util.ArrayList;
import java.util.List;
import lpg.runtime.IAst;
import lpg.runtime.IAstVisitor;

public class NestedIfLimitRule
extends AbstractRppCobolRuleWithoutDeviation {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public List<IAst> performRule(ASTNode baseNode) {
        final ArrayList<IAst> tokens = new ArrayList<IAst>();
        final int NESTING_LIMIT = Integer.parseInt(this.getParameter("NESTING_LIMIT").getValue());
        baseNode.accept((IAstVisitor)new AbstractVisitor(){

            public void unimplementedVisitor(String arg0) {
            }

            public boolean visit(IfStatement stmt) {
                this.searchIfStatement(stmt, 1);
                return true;
            }

            private void searchIfStatement(IfStatement stmt, int nestLevel) {
                StatementList s;
                if (nestLevel > NESTING_LIMIT && !tokens.contains(stmt)) {
                    tokens.add(stmt);
                    NestedIfLimitRule.this.beginingLineNumber = stmt.getLeftIToken().getLine();
                    NestedIfLimitRule.this.beginingIndexPosition = stmt.getLeftIToken().getStartOffset();
                    NestedIfLimitRule.this.endingIndexPosition = stmt.getRightIToken().getEndOffset();
                }
                if (stmt.getStatementNextSentence() instanceof StatementList) {
                    s = (StatementList)stmt.getStatementNextSentence();
                    for (Object o : s.getAllChildren()) {
                        if (!(o instanceof IfStatement)) continue;
                        this.searchIfStatement((IfStatement)o, nestLevel + 1);
                    }
                }
                if (stmt.getStatementNextSentence6() instanceof StatementList) {
                    s = (StatementList)stmt.getStatementNextSentence6();
                    for (Object o : s.getAllChildren()) {
                        if (!(o instanceof IfStatement)) continue;
                        this.searchIfStatement((IfStatement)o, nestLevel + 1);
                    }
                }
            }
        });
        return tokens;
    }

    public String getExtraLabel() {
        return this.getParameter("NESTING_LIMIT").getValue();
    }
}

