/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.qualitycontrol.cobol.rules.template;

import com.ibm.pdp.qualitycontrol.cobol.provider.AbstractRppCobolRule;
import com.ibm.pdp.qualitycontrol.cobol.provider.PDPCodeReviewProvider;
import com.ibm.pdp.qualitycontrol.collector.PdpCobolData;
import com.ibm.pdp.util.Util;
import com.ibm.rsar.analysis.codereview.cobol.CodeReviewResult;
import com.ibm.rsaz.analysis.core.element.AbstractAnalysisElement;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.result.AbstractAnalysisResult;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import com.ibm.systemz.cobol.editor.core.parser.Ast.ASTNode;
import java.util.List;
import lpg.runtime.IAst;
import org.eclipse.core.resources.IResource;

public class LengthCodeLines
extends AbstractRppCobolRule {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected int beginingLineNumber = -1;
    protected int beginingIndexPosition = -1;
    protected int endingIndexPosition = -1;
    public static final int EOL_LENGTH = System.getProperty("line.separator").length();
    int realLimit = 0;

    public void analyze(AnalysisHistory history) {
        this.beginingLineNumber = 1;
        this.beginingIndexPosition = 0;
        this.endingIndexPosition = -1;
        String limit = this.getParameter("LINELENGTH_LIMIT").getValue();
        limit = limit.replaceAll(",", "");
        this.realLimit = Integer.parseInt(limit);
        String historyId = history.getHistoryId();
        PdpCobolData pdpCobolData = ((PDPCodeReviewProvider)this.getProvider()).getPdpCobolData(historyId);
        if (pdpCobolData == null) {
            return;
        }
        List lines = Util.splitTextIntoLines((String)pdpCobolData.getEditTree().getTextProcessor().getText().toString());
        for (String line : lines) {
            int linesSize = line.length();
            if (linesSize > this.realLimit) {
                this.endingIndexPosition = this.beginingIndexPosition + linesSize;
                int lineRank = pdpCobolData.lineRankFromCharIndex(this.beginingIndexPosition);
                this.addResult(pdpCobolData.getResource(), historyId, linesSize, lineRank);
            }
            ++this.beginingLineNumber;
            this.beginingIndexPosition = this.beginingIndexPosition + linesSize + EOL_LENGTH;
        }
    }

    public void addResult(IResource resource, String historyId, int linesNumber, int rank) {
        Object violation = null;
        String extraLabel = this.getExtraLabel(linesNumber);
        violation = extraLabel == null || extraLabel.length() == 0 ? new CodeReviewResult(resource.getFullPath().toString(), this.beginingLineNumber, this.beginingIndexPosition, this.endingIndexPosition - this.beginingIndexPosition, resource, (AbstractAnalysisRule)this, historyId, true) : new AbstractRppCobolRule.CodeReviewResultWithCustomLabel((AbstractRppCobolRule)this, extraLabel, resource.getFullPath().toString(), rank + 1, this.beginingIndexPosition, this.endingIndexPosition - this.beginingIndexPosition, resource, (AbstractAnalysisRule)this, historyId);
        violation.setOwner((AbstractAnalysisElement)this);
        this.addHistoryResultSet(historyId, (AbstractAnalysisResult)violation);
    }

    protected String getExtraLabel(int lines) {
        return " : " + String.valueOf(lines) + " / " + String.valueOf(this.realLimit);
    }

    public List<IAst> performRule(ASTNode baseNode) {
        return null;
    }
}

