/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.qualitycontrol.cobol.rules.template;

import com.ibm.pdp.qualitycontrol.cobol.provider.AbstractRppCobolRuleWithoutDeviation;
import com.ibm.systemz.cobol.editor.core.parser.Ast.ASTNode;
import com.ibm.systemz.cobol.editor.core.parser.Ast.AbstractVisitor;
import com.ibm.systemz.cobol.editor.core.parser.Ast.IStatement;
import com.ibm.systemz.cobol.editor.core.parser.Ast.PerformUntil;
import com.ibm.systemz.cobol.editor.core.parser.Ast.StatementList;
import java.util.ArrayList;
import java.util.List;
import lpg.runtime.IAst;
import lpg.runtime.IAstVisitor;

public class InlinePerformLineLimitRule
extends AbstractRppCobolRuleWithoutDeviation {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public List<IAst> performRule(ASTNode baseNode) {
        int lineLimit;
        final ArrayList<IAst> tokens = new ArrayList<IAst>();
        String LINE_LIMIT = this.getParameter("LINE_LIMIT").getValue();
        if (LINE_LIMIT == null) {
            return tokens;
        }
        try {
            lineLimit = Integer.parseInt(LINE_LIMIT);
        }
        catch (NumberFormatException numberFormatException) {
            return tokens;
        }
        baseNode.accept((IAstVisitor)new AbstractVisitor(){

            public void unimplementedVisitor(String s) {
            }

            public boolean visit(PerformUntil statement) {
                if (statement.getEND_PERFORM() == null) {
                    return true;
                }
                StatementList list = statement.getStatementList();
                if (list == null) {
                    return true;
                }
                int numberOfStatements = list.size();
                if (numberOfStatements <= 1) {
                    return true;
                }
                IStatement first = list.getStatementAt(0);
                IStatement last = list.getStatementAt(numberOfStatements - 1);
                int numberOfLines = last.getLeftIToken().getLine() - first.getLeftIToken().getLine() + 1;
                if (numberOfLines > lineLimit) {
                    tokens.add(statement);
                }
                return true;
            }
        });
        return tokens;
    }

    public String getExtraLabel() {
        return this.getParameter("LINE_LIMIT").getValue();
    }
}

