/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.qualitycontrol.cobol.rules.template;

import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.qualitycontrol.cobol.provider.PDPCodeReviewProvider;
import com.ibm.pdp.qualitycontrol.cobol.rules.template.AbstractRppCobolRuleTemplateWithThresholds;
import com.ibm.pdp.qualitycontrol.collector.PdpCobolData;
import com.ibm.rsar.analysis.codereview.cobol.rules.GotoRule;
import com.ibm.systemz.cobol.editor.core.parser.Ast.ASTNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import lpg.runtime.IAst;

public class GDIOperatorRule
extends AbstractRppCobolRuleTemplateWithThresholds {
    private static final String PROGRAM_NOT_ALLOWED_GOTO = "F05";
    private static final String SCREEN_RECEPTION_NOT_ALLOWED_GOTO = "F3999-ITER-FI";
    private static final String SCREEN_DISPLAY_NOT_ALLOWED_GOTO = "F6999-ITER-FI";
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2016. All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public List<IAst> performRule(ASTNode baseNode) {
        GotoRule rule = new GotoRule();
        List<IAst> asts = rule.performRule(baseNode);
        PdpCobolData pdpCobolData = ((PDPCodeReviewProvider)this.getProvider()).getPdpCobolData(this.getHistoryId());
        if (pdpCobolData == null) {
            return asts;
        }
        asts = this.removeNotAllowedGoto(asts, pdpCobolData.getEditTree());
        this.filterResults(asts);
        if (!this.checkEntityLines(asts.size())) {
            return asts;
        }
        return new ArrayList<IAst>();
    }

    private List<IAst> removeNotAllowedGoto(List<IAst> asts, IEditTree editTree) {
        Iterator<IAst> iterator = asts.iterator();
        while (iterator.hasNext()) {
            IAst node = iterator.next();
            String function = node.getRightIToken().toString();
            if (function.equals(PROGRAM_NOT_ALLOWED_GOTO) || function.equals(SCREEN_RECEPTION_NOT_ALLOWED_GOTO) || function.equals(SCREEN_DISPLAY_NOT_ALLOWED_GOTO)) continue;
            iterator.remove();
        }
        return asts;
    }
}

