/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.qualitycontrol.cobol.rules.template;

import com.ibm.pdp.qualitycontrol.cobol.provider.AbstractRppCobolRuleWithoutDeviation;
import com.ibm.systemz.cobol.editor.core.parser.Ast.ASTNode;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lpg.runtime.IAst;

public class FileNameConventionRule
extends AbstractRppCobolRuleWithoutDeviation {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public List<IAst> performRule(ASTNode baseNode) {
        ArrayList<IAst> tokens = new ArrayList<IAst>();
        String CONVENTION_MASK = this.getParameter("CONVENTION_MASK").getValue();
        if (CONVENTION_MASK == null) {
            return tokens;
        }
        String sourceName = this.getFileName().substring(this.getFileName().lastIndexOf(File.separator) + 1);
        if (sourceName.contains(".")) {
            sourceName = sourceName.substring(0, sourceName.indexOf("."));
        }
        if (!FileNameConventionRule.fileNameMatchesRegex(sourceName, CONVENTION_MASK)) {
            tokens.add((IAst)baseNode);
        }
        return tokens;
    }

    private static boolean fileNameMatchesRegex(String sourceName, String regExString) {
        Pattern pattern = Pattern.compile(regExString);
        Matcher matcher = pattern.matcher(sourceName);
        if (!matcher.find()) {
            return false;
        }
        int startIndex = matcher.start();
        int endIndex = matcher.end();
        return startIndex == 0 && endIndex == sourceName.length();
    }

    public String getExtraLabel() {
        return this.getParameter("CONVENTION_MASK").getValue();
    }
}

