/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.qualitycontrol.cobol.rules.template;

import com.ibm.pdp.engine.ITextSegment;
import com.ibm.pdp.qualitycontrol.cobol.provider.AbstractRppCobolRule;
import com.ibm.pdp.qualitycontrol.cobol.provider.PDPCodeReviewProvider;
import com.ibm.pdp.qualitycontrol.collector.PdpCobolData;
import com.ibm.rsar.analysis.codereview.cobol.CodeReviewResult;
import com.ibm.rsaz.analysis.core.element.AbstractAnalysisElement;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.result.AbstractAnalysisResult;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import com.ibm.systemz.cobol.editor.core.parser.Ast.ASTNode;
import java.util.Iterator;
import java.util.List;
import lpg.runtime.IAst;
import org.eclipse.core.resources.IResource;

public class CountSpecificLines
extends AbstractRppCobolRule {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected int beginingLineNumber = -1;
    protected int beginingIndexPosition = -1;
    protected int endingIndexPosition = -1;
    private boolean debugEnabled = false;

    public void analyze(AnalysisHistory history) {
        int specificLinesNumber = 0;
        this.beginingLineNumber = -1;
        this.beginingIndexPosition = -1;
        this.endingIndexPosition = -1;
        this.getRealLimit();
        String historyId = history.getHistoryId();
        PdpCobolData pdpCobolData = ((PDPCodeReviewProvider)this.getProvider()).getPdpCobolData(historyId);
        if (pdpCobolData == null) {
            return;
        }
        Iterator iter = pdpCobolData.getEditTree().getTextProcessor().segments();
        int total = pdpCobolData.lineRankFromCharIndex(pdpCobolData.getText().length());
        int genLinesNumber = 0;
        while (iter.hasNext()) {
            int end;
            int begin;
            ITextSegment segment = (ITextSegment)iter.next();
            if (!segment.isGenerated()) {
                begin = segment.beginIndex();
                end = segment.endIndex();
                specificLinesNumber += this.countLinesForText(pdpCobolData, begin, end);
                if (this.beginingLineNumber == -1) {
                    this.beginingLineNumber = pdpCobolData.lineRankFromCharIndex(begin);
                    this.beginingIndexPosition = begin;
                }
                this.endingIndexPosition = end;
                continue;
            }
            if (!this.debugEnabled) continue;
            begin = segment.beginIndex();
            end = segment.endIndex();
            genLinesNumber += this.countLinesForText(pdpCobolData, begin, end);
        }
        if (this.debugEnabled) {
            System.out.println("file processed : " + pdpCobolData.getResource().getFullPath().toString());
            System.out.println("nb of specific lines : " + specificLinesNumber);
            System.out.println("nb of generated lines : " + genLinesNumber);
            System.out.println("total nb of lines :" + total);
            if (specificLinesNumber + genLinesNumber != total) {
                System.out.println("Bad result. The sum of generated + specific lines is different from the total nb of lines.");
            }
        }
        if (specificLinesNumber > this.realLimit) {
            this.addResult(pdpCobolData.getResource(), historyId, specificLinesNumber);
        }
    }

    private int countLinesForText(PdpCobolData pdpCobolData, int begin, int end) {
        if (begin == end) {
            return 0;
        }
        int line1 = pdpCobolData.lineRankFromCharIndex(begin);
        int line2 = pdpCobolData.lineRankFromCharIndex(end);
        return line2 - line1;
    }

    public void addResult(IResource resource, String historyId, int linesNumber) {
        Object violation = null;
        String extraLabel = this.getExtraLabel(linesNumber);
        violation = extraLabel == null || extraLabel.length() == 0 ? new CodeReviewResult(resource.getFullPath().toString(), this.beginingLineNumber, this.beginingIndexPosition, this.endingIndexPosition - this.beginingIndexPosition, resource, (AbstractAnalysisRule)this, historyId, true) : new AbstractRppCobolRule.CodeReviewResultWithCustomLabel((AbstractRppCobolRule)this, extraLabel, resource.getFullPath().toString(), 0, this.beginingIndexPosition, this.endingIndexPosition - this.beginingIndexPosition, resource, (AbstractAnalysisRule)this, historyId);
        violation.setOwner((AbstractAnalysisElement)this);
        this.addHistoryResultSet(historyId, (AbstractAnalysisResult)violation);
    }

    protected String getExtraLabel(int lines) {
        return " : " + String.valueOf(lines) + " vs maximum " + String.valueOf(this.realLimit);
    }

    public List<IAst> performRule(ASTNode baseNode) {
        return null;
    }
}

