/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.qualitycontrol.cobol.rules.template;

import com.ibm.pdp.qualitycontrol.cobol.provider.AbstractRppCobolRuleWithoutDeviation;
import com.ibm.systemz.cobol.editor.core.copy.parser.Ast.CopyStatement;
import com.ibm.systemz.cobol.editor.core.parser.Ast.ASTNode;
import java.util.ArrayList;
import java.util.List;
import lpg.runtime.IAst;

public class CopybookRule
extends AbstractRppCobolRuleWithoutDeviation {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public List<IAst> performRule(ASTNode baseNode) {
        ArrayList<IAst> tokens = new ArrayList<IAst>();
        String COPYBOOK = this.getParameter("COPYBOOK_NAME").getValue();
        if (COPYBOOK == null) {
            return tokens;
        }
        List copyStatements = this.getResource().getCopybooks();
        for (IAst statement : copyStatements) {
            try {
                CopyStatement stmt = (CopyStatement)statement;
                String copybook = stmt.getTextNameLiteral().toString();
                if (copybook == null || !copybook.equalsIgnoreCase(COPYBOOK)) continue;
                tokens.add((IAst)stmt);
                this.beginingLineNumber = stmt.getLeftIToken().getLine();
                this.beginingIndexPosition = stmt.getLeftIToken().getStartOffset();
                this.endingIndexPosition = stmt.getRightIToken().getEndOffset();
            }
            catch (Exception exception) {}
        }
        return tokens;
    }

    public String getExtraLabel() {
        return this.getParameter("COPYBOOK_NAME").getValue();
    }
}

