/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.qualitycontrol.cobol.rules.template;

import com.ibm.pdp.qualitycontrol.cobol.provider.AbstractRppCobolRuleWithoutDeviation;
import com.ibm.systemz.cobol.editor.core.copy.parser.Ast.ReplaceStatement;
import com.ibm.systemz.cobol.editor.core.parser.Ast.ASTNode;
import com.ibm.systemz.cobol.editor.core.parser.Ast.AbstractVisitor;
import com.ibm.systemz.cobol.editor.core.parser.Ast.BasisStatement;
import com.ibm.systemz.cobol.editor.core.parser.Ast.CblStatement;
import com.ibm.systemz.cobol.editor.core.parser.Ast.CopyStatement;
import com.ibm.systemz.cobol.editor.core.parser.Ast.EjectStatement;
import com.ibm.systemz.cobol.editor.core.parser.Ast.ServiceLabelStatement;
import com.ibm.systemz.cobol.editor.core.parser.Ast.ServiceReloadStatement;
import com.ibm.systemz.cobol.editor.core.parser.Ast.SkipStatement;
import com.ibm.systemz.cobol.editor.core.parser.Ast.TitleStatement;
import com.ibm.systemz.cobol.editor.core.parser.CobolLexerImpl;
import com.ibm.systemz.cobol.editor.core.parser.CobolLexerLpgLexStream;
import java.util.ArrayList;
import java.util.List;
import lpg.runtime.IAst;
import lpg.runtime.IAstVisitor;
import lpg.runtime.IPrsStream;
import lpg.runtime.IToken;

public class CompilerDirectivesRule
extends AbstractRppCobolRuleWithoutDeviation {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    boolean isBASIS_DIRECTIVE = false;
    boolean isPROCESS_DIRECTIVE = false;
    boolean isCOPY_DIRECTIVE = false;
    boolean isEJECT_DIRECTIVE = false;
    boolean isREPLACE_DIRECTIVE = false;
    boolean isSERVICELABEL_DIRECTIVE = false;
    boolean isSERVICERELOAD_DIRECTIVE = false;
    boolean isSKIP_DIRECTIVE = false;
    boolean isTITLE_DIRECTIVE = false;

    static {
        try {
            Class.forName("com.ibm.systemz.cobol.editor.core.parser.Ast.ReplaceStatement");
        }
        catch (ClassNotFoundException classNotFoundException) {}
        try {
            Class.forName("com.ibm.systemz.cobol.editor.core.parser.Ast.ReplaceStatement0");
            Class.forName("com.ibm.systemz.cobol.editor.core.parser.Ast.ReplaceStatement1");
            Class.forName("com.ibm.systemz.cobol.editor.core.parser.Ast.ReplaceStatement2");
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    public List<IAst> performRule(ASTNode baseNode) {
        final boolean BASIS_DIRECTIVE = this.getParameter("BASIS_DIRECTIVE").getValue().equals("true");
        final boolean PROCESS_DIRECTIVE = this.getParameter("PROCESS_DIRECTIVE").getValue().equals("true");
        final boolean COPY_DIRECTIVE = this.getParameter("COPY_DIRECTIVE").getValue().equals("true");
        final boolean EJECT_DIRECTIVE = this.getParameter("EJECT_DIRECTIVE").getValue().equals("true");
        boolean REPLACE_DIRECTIVE = this.getParameter("REPLACE_DIRECTIVE").getValue().equals("true");
        final boolean SERVICELABEL_DIRECTIVE = this.getParameter("SERVICELABEL_DIRECTIVE").getValue().equals("true");
        final boolean SERVICERELOAD_DIRECTIVE = this.getParameter("SERVICERELOAD_DIRECTIVE").getValue().equals("true");
        final boolean SKIP_DIRECTIVE = this.getParameter("SKIP_DIRECTIVE").getValue().equals("true");
        final boolean TITLE_DIRECTIVE = this.getParameter("TITLE_DIRECTIVE").getValue().equals("true");
        final ArrayList<IAst> tokens = new ArrayList<IAst>();
        baseNode.accept((IAstVisitor)new AbstractVisitor(){

            public void unimplementedVisitor(String s) {
            }

            public boolean visit(BasisStatement stmt) {
                if (BASIS_DIRECTIVE) {
                    tokens.add(stmt);
                    CompilerDirectivesRule.this.beginingLineNumber = stmt.getLeftIToken().getLine();
                    CompilerDirectivesRule.this.beginingIndexPosition = stmt.getLeftIToken().getStartOffset();
                    CompilerDirectivesRule.this.endingIndexPosition = stmt.getRightIToken().getEndOffset();
                    CompilerDirectivesRule.this.isBASIS_DIRECTIVE = true;
                }
                return true;
            }

            public boolean visit(CblStatement stmt) {
                if (PROCESS_DIRECTIVE) {
                    tokens.add(stmt);
                    CompilerDirectivesRule.this.beginingLineNumber = stmt.getLeftIToken().getLine();
                    CompilerDirectivesRule.this.beginingIndexPosition = stmt.getLeftIToken().getStartOffset();
                    CompilerDirectivesRule.this.endingIndexPosition = stmt.getRightIToken().getEndOffset();
                    CompilerDirectivesRule.this.isPROCESS_DIRECTIVE = true;
                }
                return true;
            }

            public boolean visit(CopyStatement stmt) {
                if (COPY_DIRECTIVE) {
                    tokens.add(stmt);
                    CompilerDirectivesRule.this.beginingLineNumber = stmt.getLeftIToken().getLine();
                    CompilerDirectivesRule.this.beginingIndexPosition = stmt.getLeftIToken().getStartOffset();
                    CompilerDirectivesRule.this.endingIndexPosition = stmt.getRightIToken().getEndOffset();
                    CompilerDirectivesRule.this.isCOPY_DIRECTIVE = true;
                }
                return true;
            }

            public boolean visit(EjectStatement stmt) {
                if (EJECT_DIRECTIVE) {
                    tokens.add(stmt);
                    CompilerDirectivesRule.this.beginingLineNumber = stmt.getLeftIToken().getLine();
                    CompilerDirectivesRule.this.beginingIndexPosition = stmt.getLeftIToken().getStartOffset();
                    CompilerDirectivesRule.this.endingIndexPosition = stmt.getRightIToken().getEndOffset();
                    CompilerDirectivesRule.this.isEJECT_DIRECTIVE = true;
                }
                return true;
            }

            public boolean visit(ServiceLabelStatement stmt) {
                if (SERVICELABEL_DIRECTIVE) {
                    tokens.add(stmt);
                    CompilerDirectivesRule.this.beginingLineNumber = stmt.getLeftIToken().getLine();
                    CompilerDirectivesRule.this.beginingIndexPosition = stmt.getLeftIToken().getStartOffset();
                    CompilerDirectivesRule.this.endingIndexPosition = stmt.getRightIToken().getEndOffset();
                    CompilerDirectivesRule.this.isSERVICELABEL_DIRECTIVE = true;
                }
                return true;
            }

            public boolean visit(ServiceReloadStatement stmt) {
                if (SERVICERELOAD_DIRECTIVE) {
                    tokens.add(stmt);
                    CompilerDirectivesRule.this.beginingLineNumber = stmt.getLeftIToken().getLine();
                    CompilerDirectivesRule.this.beginingIndexPosition = stmt.getLeftIToken().getStartOffset();
                    CompilerDirectivesRule.this.endingIndexPosition = stmt.getRightIToken().getEndOffset();
                    CompilerDirectivesRule.this.isSERVICERELOAD_DIRECTIVE = true;
                }
                return true;
            }

            public boolean visit(SkipStatement stmt) {
                if (SKIP_DIRECTIVE) {
                    tokens.add(stmt);
                    CompilerDirectivesRule.this.beginingLineNumber = stmt.getLeftIToken().getLine();
                    CompilerDirectivesRule.this.beginingIndexPosition = stmt.getLeftIToken().getStartOffset();
                    CompilerDirectivesRule.this.endingIndexPosition = stmt.getRightIToken().getEndOffset();
                    CompilerDirectivesRule.this.isSKIP_DIRECTIVE = true;
                }
                return true;
            }

            public boolean visit(TitleStatement stmt) {
                if (TITLE_DIRECTIVE) {
                    tokens.add(stmt);
                    CompilerDirectivesRule.this.beginingLineNumber = stmt.getLeftIToken().getLine();
                    CompilerDirectivesRule.this.beginingIndexPosition = stmt.getLeftIToken().getStartOffset();
                    CompilerDirectivesRule.this.endingIndexPosition = stmt.getRightIToken().getEndOffset();
                    CompilerDirectivesRule.this.isTITLE_DIRECTIVE = true;
                }
                return true;
            }
        });
        if (COPY_DIRECTIVE) {
            List copybooks = this.getResource().getCopybooks();
            for (IAst copybook : copybooks) {
                if (!(copybook instanceof com.ibm.systemz.cobol.editor.core.copy.parser.Ast.CopyStatement)) continue;
                tokens.add(copybook);
                this.beginingLineNumber = copybook.getLeftIToken().getLine();
                this.beginingIndexPosition = copybook.getLeftIToken().getStartOffset();
                this.endingIndexPosition = copybook.getRightIToken().getEndOffset();
                this.isCOPY_DIRECTIVE = true;
            }
        }
        if (REPLACE_DIRECTIVE) {
            if (baseNode != null && baseNode.getClass().getName().startsWith("com.ibm.systemz.cobol.editor.core.parser.Ast.ReplaceStatement")) {
                tokens.add((IAst)baseNode);
                this.beginingLineNumber = baseNode.getLeftIToken().getLine();
                this.beginingIndexPosition = baseNode.getLeftIToken().getStartOffset();
                this.endingIndexPosition = baseNode.getRightIToken().getEndOffset();
                this.isREPLACE_DIRECTIVE = true;
            }
            IPrsStream prsStream = baseNode.getLeftIToken().getIPrsStream();
            ArrayList adjuncts = prsStream.getAdjuncts();
            for (Object o : adjuncts) {
                CobolLexerLpgLexStream lexStream;
                ReplaceStatement replaceStmt;
                if (!(o instanceof IToken)) continue;
                IToken token = (IToken)o;
                int replaceKind = this.getCobolParsersymTokenFieldName("TK_REPLACE");
                if (token.getKind() != replaceKind || !(prsStream.getILexStream() instanceof CobolLexerLpgLexStream) || (replaceStmt = (lexStream = (CobolLexerLpgLexStream)prsStream.getILexStream()).getBaseIncludeStatementHandler().parseReplaceStmt(lexStream.getInputChars(), ((IToken)o).getStartOffset(), (CobolLexerImpl)lexStream.getLexer())) == null) continue;
                tokens.add((IAst)replaceStmt);
                this.beginingLineNumber = replaceStmt.getLeftIToken().getLine();
                this.beginingIndexPosition = replaceStmt.getLeftIToken().getStartOffset();
                this.endingIndexPosition = replaceStmt.getRightIToken().getEndOffset();
                this.isREPLACE_DIRECTIVE = true;
            }
        }
        return tokens;
    }

    public String getExtraLabel() {
        ArrayList<String> lsCompile = new ArrayList<String>();
        if (this.isCOPY_DIRECTIVE) {
            lsCompile.add("COPY");
        }
        if (this.isEJECT_DIRECTIVE) {
            lsCompile.add("EJECT");
        }
        if (this.isREPLACE_DIRECTIVE) {
            lsCompile.add("REPLACE");
        }
        if (this.isSERVICELABEL_DIRECTIVE) {
            lsCompile.add("SERVICE");
        }
        if (this.isSERVICERELOAD_DIRECTIVE) {
            lsCompile.add("RELOAD");
        }
        if (this.isSKIP_DIRECTIVE) {
            lsCompile.add("SKIP");
        }
        if (this.isTITLE_DIRECTIVE) {
            lsCompile.add("TITLE");
        }
        if (this.isPROCESS_DIRECTIVE) {
            lsCompile.add("CBL (PROCESS)");
        }
        if (this.isBASIS_DIRECTIVE) {
            lsCompile.add("BASIS");
        }
        return ((Object)lsCompile).toString();
    }
}

