/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.qualitycontrol.cobol.rules.template;

import com.ibm.pdp.qualitycontrol.cobol.provider.AbstractRppCobolRule;
import com.ibm.rsaz.analysis.core.element.AnalysisParameter;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;

public abstract class AbstractRppCobolRuleTemplateWithThresholds
extends AbstractRppCobolRule {
    private int normality;
    private int deviation;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void preAnalyze(AnalysisHistory history) {
        super.preAnalyze(history);
        this.normality = this.getIntParameter("normality");
        this.deviation = this.getIntParameter("deviation");
    }

    public void postAnalyze(AnalysisHistory history) {
        super.postAnalyze(history);
        AnalysisParameter analysisParameter = this.getParameter("SEVERITY");
        if (this.normality > 0) {
            analysisParameter.setValue("0");
        }
    }

    protected boolean checkEntityLines(int lines) {
        switch (this.normality) {
            case 0: {
                return this.checkDeviation(lines);
            }
        }
        return this.checkNormality(lines);
    }

    private boolean checkNormality(int value) {
        return this.normality >= value || value >= this.deviation;
    }

    private boolean checkDeviation(int value) {
        return value <= this.deviation;
    }

    private int getIntParameter(String field) {
        int parameter;
        try {
            parameter = Integer.parseInt(this.getParameter(field).getValue());
        }
        catch (NumberFormatException numberFormatException) {
            parameter = 0;
        }
        return parameter;
    }

    protected boolean isResultFiltered() {
        return false;
    }
}

