/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.qualitycontrol.cobol.rules.template;

import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.TextStatus;
import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.qualitycontrol.cobol.provider.AbstractRppCobolRule;
import com.ibm.pdp.qualitycontrol.cobol.provider.PDPCodeReviewProvider;
import com.ibm.pdp.qualitycontrol.cobol.rules.template.AbstractRppCobolRuleTemplateWithThresholds;
import com.ibm.pdp.qualitycontrol.collector.PdpCobolData;
import com.ibm.rsar.analysis.codereview.cobol.CodeReviewResult;
import com.ibm.rsaz.analysis.core.element.AbstractAnalysisElement;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.result.AbstractAnalysisResult;
import com.ibm.rsaz.analysis.core.result.ResourceAnalysisResult;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import com.ibm.systemz.cobol.editor.core.parser.Ast.ASTNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import lpg.runtime.IAst;
import org.eclipse.core.resources.IResource;

public abstract class AbstractNoMacroOverrideRule
extends AbstractRppCobolRuleTemplateWithThresholds {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2021. All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private int lastViolationLineRank;
    private int lastViolationEndIndex;

    public void analyze(AnalysisHistory history) {
        ArrayList<ResourceAnalysisResult> violations = new ArrayList<ResourceAnalysisResult>();
        String historyId = history.getHistoryId();
        PdpCobolData pdpCobolData = ((PDPCodeReviewProvider)this.getProvider()).getPdpCobolData(historyId);
        if (pdpCobolData != null) {
            this.findOverwrittenMacroLines(historyId, pdpCobolData, violations);
            if (!this.checkEntityLines(violations.size())) {
                for (ResourceAnalysisResult violation : violations) {
                    this.addHistoryResultSet(historyId, (AbstractAnalysisResult)violation);
                }
            }
        }
    }

    private void findOverwrittenMacroLines(String historyId, PdpCobolData pdpCobolData, List<ResourceAnalysisResult> listResult) {
        this.lastViolationLineRank = -1;
        this.lastViolationEndIndex = -1;
        IEditTree editTree = pdpCobolData.getEditTree();
        ITextNode workingDivisionRoot = this.findSection(editTree);
        if (workingDivisionRoot != null) {
            this.findOverwrittenMacroLinesInto(historyId, pdpCobolData, workingDivisionRoot, listResult);
        }
    }

    protected abstract ITextNode findSection(IEditTree var1);

    private void findOverwrittenMacroLinesInto(String historyId, PdpCobolData pdpCobolData, ITextNode node, List<ResourceAnalysisResult> listResult) {
        IGeneratedTag tag;
        TextStatus status = node.getTextStatus();
        if ((status == TextStatus.Deleted || status == TextStatus.Modified) && (tag = node.enclosingGeneratedTag()) != null && tag.getProperty("msp") != null) {
            int beginIdx = node.beginIndex();
            int lineRank = pdpCobolData.lineRankFromCharIndex(beginIdx);
            this.addResult(pdpCobolData.getResource(), historyId, beginIdx, node.endIndex(), lineRank, listResult);
        }
        if (node.includeUserSubNode()) {
            Iterator subnodes = node.sons();
            while (subnodes.hasNext()) {
                this.findOverwrittenMacroLinesInto(historyId, pdpCobolData, (ITextNode)subnodes.next(), listResult);
            }
        }
    }

    private void addResult(IResource resource, String historyId, int beginIdx, int endIdx, int lineRank, List<ResourceAnalysisResult> listResult) {
        if (lineRank >= this.lastViolationLineRank || beginIdx > this.lastViolationEndIndex) {
            this.lastViolationLineRank = lineRank;
            this.lastViolationEndIndex = endIdx;
            String extraLabel = this.getExtraLabel();
            Object result = null;
            result = extraLabel == null || extraLabel.length() == 0 ? new CodeReviewResult(resource.getFullPath().toString(), 1 + lineRank, beginIdx, endIdx - beginIdx, resource, (AbstractAnalysisRule)this, historyId, true) : new AbstractRppCobolRule.CodeReviewResultWithCustomLabel((AbstractRppCobolRule)this, extraLabel, resource.getFullPath().toString(), 1 + lineRank, beginIdx, endIdx - beginIdx, resource, (AbstractAnalysisRule)this, historyId);
            result.setOwner((AbstractAnalysisElement)this);
            listResult.add((ResourceAnalysisResult)result);
        }
    }

    public List<IAst> performRule(ASTNode baseNode) {
        return null;
    }
}

