/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.qualitycontrol.cobol.rules.template;

import com.ibm.pdp.qualitycontrol.cobol.provider.AbstractRppCobolRule;
import com.ibm.pdp.qualitycontrol.cobol.provider.AbstractRppCobolRuleWithoutDeviation;
import com.ibm.rsar.analysis.codereview.cobol.CodeReviewResult;
import com.ibm.rsaz.analysis.core.element.AbstractAnalysisElement;
import com.ibm.rsaz.analysis.core.result.AbstractAnalysisResult;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import com.ibm.systemz.cobol.editor.core.parser.Ast.ASTNode;
import java.util.ArrayList;
import java.util.List;
import lpg.runtime.IAst;
import lpg.runtime.IPrsStream;
import lpg.runtime.IToken;
import org.eclipse.core.resources.IResource;

public abstract class AbstractCommentRule
extends AbstractRppCobolRuleWithoutDeviation {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final int BEFORE = 0;
    protected static final int AFTER = 1;

    public List<IAst> performRule(ASTNode baseNode) {
        int location;
        String LOCATION = this.getParameter("LOCATION").getValue();
        if (LOCATION == null) {
            return new ArrayList<IAst>();
        }
        try {
            location = Integer.parseInt(LOCATION);
        }
        catch (NumberFormatException numberFormatException) {
            return new ArrayList<IAst>();
        }
        return this.collectCommentViolations(baseNode, location);
    }

    protected abstract List<IAst> collectCommentViolations(ASTNode var1, int var2);

    protected boolean isPrecededByComment(ASTNode node) {
        IToken token = node.getLeftIToken();
        IPrsStream stream = token.getIPrsStream();
        IToken[] preceding = stream.getPrecedingAdjuncts(token.getTokenIndex());
        int kind = this.getCobolParsersymTokenFieldName("TK_SINGLE_LINE_COMMENT");
        IToken[] iTokenArray = preceding;
        int n = preceding.length;
        int n2 = 0;
        while (n2 < n) {
            IToken t = iTokenArray[n2];
            if (t.getKind() == kind) {
                String s = t.toString();
                if (s.length() > 66) {
                    s = s.substring(0, 66);
                }
                if (s.trim().length() > 1) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    protected boolean isFollowedByComment(ASTNode node) {
        IToken token = node.getRightIToken();
        IPrsStream stream = token.getIPrsStream();
        IToken[] following = stream.getFollowingAdjuncts(token.getTokenIndex() + 1);
        int kind = this.getCobolParsersymTokenFieldName("TK_SINGLE_LINE_COMMENT");
        IToken[] iTokenArray = following;
        int n = following.length;
        int n2 = 0;
        while (n2 < n) {
            IToken t = iTokenArray[n2];
            if (t.getKind() == kind) {
                String s = t.toString();
                if (s.length() > 66) {
                    s = s.substring(0, 66);
                }
                if (s.trim().length() > 1) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    protected void addResult(IResource resource, String historyId, List<IAst> results) {
        int i = 0;
        while (i < results.size()) {
            IAst node = results.get(i);
            this.beginingLineNumber = node.getLeftIToken().getLine();
            this.beginingIndexPosition = node.getLeftIToken().getStartOffset();
            this.endingIndexPosition = node.getRightIToken().getEndOffset();
            Object result = null;
            String extraLabel = this.getExtraLabel(node);
            result = extraLabel == null || extraLabel.length() == 0 ? new CodeReviewResult(resource.getFullPath().toString(), this.beginingLineNumber, this.beginingIndexPosition, this.endingIndexPosition - this.beginingIndexPosition, resource, (AbstractAnalysisRule)this, historyId, true) : new AbstractRppCobolRule.CodeReviewResultWithCustomLabel((AbstractRppCobolRule)this, extraLabel, resource.getFullPath().toString(), this.beginingLineNumber, this.beginingIndexPosition, this.endingIndexPosition - this.beginingIndexPosition, resource, (AbstractAnalysisRule)this, historyId);
            result.setOwner((AbstractAnalysisElement)this);
            this.addHistoryResultSet(historyId, (AbstractAnalysisResult)result);
            ++i;
        }
    }

    protected String getExtraLabel(IAst node) {
        return "";
    }
}

