/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.qualitycontrol.cobol.rules;

import com.ibm.pdp.engine.TextStatus;
import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.qualitycontrol.cobol.provider.PDPCodeReviewProvider;
import com.ibm.pdp.qualitycontrol.collector.PdpCobolData;
import com.ibm.rsar.analysis.codereview.cobol.CodeReviewResult;
import com.ibm.rsaz.analysis.core.element.AbstractAnalysisElement;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.result.AbstractAnalysisResult;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;

public class UserFunctionMustHaveComment
extends AbstractAnalysisRule {
    protected int lastViolationLineRank;
    protected int lastViolationEndIndex;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2011, 2016. All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void analyze(AnalysisHistory history) {
        String historyId = history.getHistoryId();
        PdpCobolData pdpCobolData = ((PDPCodeReviewProvider)this.getProvider()).getPdpCobolData(historyId);
        if (pdpCobolData != null) {
            this.findUserFunctionsWithoutComment(historyId, pdpCobolData);
        }
    }

    protected void findUserFunctionsWithoutComment(String historyId, PdpCobolData pdpCobolData) {
        this.lastViolationLineRank = -1;
        this.lastViolationEndIndex = -1;
        IEditTree editTree = pdpCobolData.getEditTree();
        ITextNode procedureDivisionRoot = this.findProcedureDivision(editTree);
        if (procedureDivisionRoot != null) {
            this.findUserFunctionsWithoutComment(historyId, pdpCobolData, procedureDivisionRoot);
        }
    }

    protected ITextNode findProcedureDivision(IEditTree editTree) {
        return editTree.nodeFromTagName("PROCEDURE");
    }

    protected void findUserFunctionsWithoutComment(String historyId, PdpCobolData pdpCobolData, ITextNode node) {
        int beginIdx;
        int lineRank;
        TextStatus status = node.getTextStatus();
        if (status.isUserText() && node.isSyntacticTag() && !this.existNonEmptyCommentLineBefore(pdpCobolData, lineRank = pdpCobolData.lineRankFromCharIndex(beginIdx = node.beginIndex())) && !this.existNonEmptyCommentLineAfter(pdpCobolData, lineRank)) {
            this.addResult(pdpCobolData.getResource(), historyId, beginIdx, node.endIndex(), lineRank);
        }
        if (!node.includeUserSubNode()) {
            return;
        }
        Iterator subnodes = node.sons();
        while (subnodes.hasNext()) {
            this.findUserFunctionsWithoutComment(historyId, pdpCobolData, (ITextNode)subnodes.next());
        }
    }

    protected boolean existNonEmptyCommentLineBefore(PdpCobolData pdpCobolData, int lineRank) {
        CharSequence cobol = pdpCobolData.getText();
        int nextLineIndex = pdpCobolData.lineStartIndex(lineRank);
        while (--lineRank >= 0) {
            int lineBeginIndex = pdpCobolData.lineStartIndex(lineRank);
            LineType lineStatus = this.lineStatus(lineBeginIndex, nextLineIndex, cobol);
            if (lineStatus != LineType.BLANK) {
                return lineStatus == LineType.NON_BLANK_COMMENT;
            }
            nextLineIndex = lineBeginIndex;
        }
        return false;
    }

    protected boolean existNonEmptyCommentLineAfter(PdpCobolData pdpCobolData, int lineRank) {
        CharSequence cobol = pdpCobolData.getText();
        int nbLines = pdpCobolData.getLineStartIndexes().length;
        int lineBeginIndex = pdpCobolData.lineStartIndex(lineRank);
        while (++lineRank < nbLines) {
            int nextLineIndex = pdpCobolData.lineStartIndex(lineRank);
            LineType lineStatus = this.lineStatus(lineBeginIndex, nextLineIndex, cobol);
            if (lineStatus != LineType.BLANK) {
                return lineStatus == LineType.NON_BLANK_COMMENT;
            }
            lineBeginIndex = nextLineIndex;
        }
        LineType lineStatus = this.lineStatus(lineBeginIndex, cobol.length(), cobol);
        return lineStatus == LineType.NON_BLANK_COMMENT;
    }

    protected LineType lineStatus(int lineBeginIndex, int nextLineIndex, CharSequence cobol) {
        int column7Idx = lineBeginIndex + 6;
        if (column7Idx >= nextLineIndex) {
            return LineType.BLANK;
        }
        char c = cobol.charAt(column7Idx);
        if (c != '*' && c != '/') {
            return LineType.NO_COMMENT;
        }
        int max = Math.min(column7Idx + 66, nextLineIndex);
        int idx = column7Idx + 1;
        while (idx < max) {
            c = cobol.charAt(idx);
            if (c == '\n' || c == '\r') {
                return LineType.BLANK;
            }
            if (!Character.isWhitespace(c)) {
                return LineType.NON_BLANK_COMMENT;
            }
            ++idx;
        }
        return LineType.BLANK;
    }

    public void addResult(IResource resource, String historyId, int beginIdx, int endIdx, int lineRank) {
        if (lineRank <= this.lastViolationLineRank || beginIdx < this.lastViolationEndIndex) {
            return;
        }
        this.lastViolationLineRank = lineRank;
        this.lastViolationEndIndex = endIdx;
        CodeReviewResult violation = new CodeReviewResult(resource.getFullPath().toString(), 1 + lineRank, beginIdx, endIdx - beginIdx, resource, (AbstractAnalysisRule)this, historyId, true);
        violation.setOwner((AbstractAnalysisElement)this);
        this.addHistoryResultSet(historyId, (AbstractAnalysisResult)violation);
    }

    private static enum LineType {
        BLANK,
        NON_BLANK_COMMENT,
        NO_COMMENT;

    }
}

