/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.qualitycontrol.cobol.rules;

import com.ibm.pdp.qualitycontrol.cobol.provider.PDPCodeReviewProvider;
import com.ibm.pdp.qualitycontrol.collector.PdpCobolData;
import com.ibm.pdp.references.service.ReferenceService;
import com.ibm.rsar.analysis.codereview.cobol.CodeReviewResult;
import com.ibm.rsaz.analysis.core.element.AbstractAnalysisElement;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.result.AbstractAnalysisResult;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;

public class SynchronizedCobolRule
extends AbstractAnalysisRule {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void analyze(AnalysisHistory history) {
        boolean result;
        String historyId = history.getHistoryId();
        PdpCobolData pdpCobolData = ((PDPCodeReviewProvider)this.getProvider()).getPdpCobolData(historyId);
        if (pdpCobolData != null && (result = ReferenceService.checkDesynchronizationWithDesigns((String)pdpCobolData.getResource().getFullPath().toString()))) {
            CodeReviewResult violation = new CodeReviewResult(pdpCobolData.getResource().getFullPath().toString(), 0, 0, 0, pdpCobolData.getResource(), (AbstractAnalysisRule)this, historyId, true);
            violation.setOwner((AbstractAnalysisElement)this);
            this.addHistoryResultSet(historyId, (AbstractAnalysisResult)violation);
        }
    }
}

