/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.qualitycontrol.cobol.rules;

import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.qualitycontrol.cobol.provider.AbstractRppCobolRule;
import com.ibm.pdp.qualitycontrol.cobol.provider.PDPCodeReviewProvider;
import com.ibm.pdp.qualitycontrol.cobol.rules.CallStatementRule;
import com.ibm.pdp.qualitycontrol.collector.PdpCobolData;
import com.ibm.systemz.cobol.editor.core.parser.Ast.ASTNode;
import java.util.Iterator;
import java.util.List;
import lpg.runtime.IAst;

public class RppCallStatementRule
extends AbstractRppCobolRule {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2011, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public List<IAst> performRule(ASTNode baseNode) {
        List<IAst> asts = new CallStatementRule().performRule(baseNode);
        PdpCobolData pdpCobolData = ((PDPCodeReviewProvider)this.getProvider()).getPdpCobolData(this.getHistoryId());
        if (pdpCobolData == null) {
            return asts;
        }
        return this.removeAuthorizedCallStatement(asts, pdpCobolData.getEditTree());
    }

    private List<IAst> removeAuthorizedCallStatement(List<IAst> asts, IEditTree editTree) {
        Iterator<IAst> iterator = asts.iterator();
        while (iterator.hasNext()) {
            int endIdx;
            IAst node = iterator.next();
            int beginIdx = node.getLeftIToken().getStartOffset();
            ITextNode textNode = editTree.includingNode(beginIdx, endIdx = node.getRightIToken().getEndOffset());
            if (!this.checkAllowedNodes(textNode)) continue;
            iterator.remove();
        }
        return asts;
    }

    private boolean checkAllowedNodes(ITextNode textNode) {
        String tagname = textNode.enclosingTagName();
        if (tagname.startsWith("F97") || tagname.startsWith("F99")) {
            return true;
        }
        ITextNode parentNode = textNode.parentNode();
        if (parentNode == null) {
            return false;
        }
        return this.checkAllowedNodes(parentNode);
    }
}

