/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.qualitycontrol.cobol.rules;

import com.ibm.pdp.engine.TextStatus;
import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.qualitycontrol.cobol.provider.PDPCodeReviewProvider;
import com.ibm.pdp.qualitycontrol.collector.PdpCobolData;
import com.ibm.rsar.analysis.codereview.cobol.CodeReviewResult;
import com.ibm.rsaz.analysis.core.element.AbstractAnalysisElement;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.result.AbstractAnalysisResult;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;

public class NoUserCodeOutsideOfUserFunctionRule
extends AbstractAnalysisRule {
    protected int lastViolationLineRank;
    protected int lastViolationEndIndex;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2011, 2016. All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void analyze(AnalysisHistory history) {
        String historyId = history.getHistoryId();
        PdpCobolData pdpCobolData = ((PDPCodeReviewProvider)this.getProvider()).getPdpCobolData(historyId);
        if (pdpCobolData != null) {
            this.findOverwrittenGeneratedLines(historyId, pdpCobolData);
        }
    }

    protected void findOverwrittenGeneratedLines(String historyId, PdpCobolData pdpCobolData) {
        this.lastViolationLineRank = -1;
        this.lastViolationEndIndex = -1;
        IEditTree editTree = pdpCobolData.getEditTree();
        ITextNode procedureDivisionRoot = this.findProcedureDivision(editTree);
        if (procedureDivisionRoot != null) {
            this.findUserCodeNotInUserFunction(historyId, pdpCobolData, procedureDivisionRoot);
        }
    }

    protected ITextNode findProcedureDivision(IEditTree editTree) {
        return editTree.nodeFromTagName("PROCEDURE");
    }

    protected void findUserCodeNotInUserFunction(String historyId, PdpCobolData pdpCobolData, ITextNode node) {
        int endIdx;
        int beginIdx;
        TextStatus status = node.getTextStatus();
        if (status.isUserText() && !node.isSyntacticTag() && !node.enclosingTagName().equals("PROCEDURE-DIVISION") && !this.isPureComment(pdpCobolData, beginIdx = node.beginIndex(), endIdx = node.endIndex())) {
            int lineRank = pdpCobolData.lineRankFromCharIndex(beginIdx);
            this.addResult(pdpCobolData.getResource(), historyId, beginIdx, endIdx, lineRank);
        }
        if (!node.includeUserSubNode()) {
            return;
        }
        Iterator subnodes = node.sons();
        while (subnodes.hasNext()) {
            this.findUserCodeNotInUserFunction(historyId, pdpCobolData, (ITextNode)subnodes.next());
        }
    }

    protected boolean isPureComment(PdpCobolData pdpCobolData, int beginIdx, int endIdx) {
        if (endIdx <= beginIdx) {
            return false;
        }
        int lineBeginRank = pdpCobolData.lineRankFromCharIndex(beginIdx);
        int lineEndRank = pdpCobolData.lineRankFromCharIndex(endIdx);
        if (pdpCobolData.lineStartIndex(lineEndRank) == endIdx) {
            --lineEndRank;
        }
        CharSequence text = pdpCobolData.getText();
        int lineRank = lineBeginRank;
        while (lineRank <= lineEndRank) {
            int lineStopIdx;
            int lineStartIdx = pdpCobolData.lineStartIndex(lineRank);
            if (!this.isCommentOrBlankLine(lineStartIdx, lineStopIdx = pdpCobolData.lineStopIndex(lineRank), text)) {
                return false;
            }
            ++lineRank;
        }
        return true;
    }

    protected boolean isCommentOrBlankLine(int lineStartIdx, int lineStopIdx, CharSequence text) {
        if (lineStopIdx - lineStartIdx < 7) {
            return true;
        }
        char c = text.charAt(lineStartIdx + 6);
        if (c == '*' || c == '/') {
            return true;
        }
        if (c != ' ') {
            return false;
        }
        int idx = lineStartIdx + 7;
        while (idx < lineStopIdx) {
            if (!Character.isWhitespace(text.charAt(idx))) {
                return false;
            }
            ++idx;
        }
        return true;
    }

    public void addResult(IResource resource, String historyId, int beginIdx, int endIdx, int lineRank) {
        if (lineRank <= this.lastViolationLineRank || beginIdx < this.lastViolationEndIndex) {
            return;
        }
        this.lastViolationLineRank = lineRank;
        this.lastViolationEndIndex = endIdx;
        CodeReviewResult violation = new CodeReviewResult(resource.getFullPath().toString(), 1 + lineRank, beginIdx, endIdx - beginIdx, resource, (AbstractAnalysisRule)this, historyId, true);
        violation.setOwner((AbstractAnalysisElement)this);
        this.addHistoryResultSet(historyId, (AbstractAnalysisResult)violation);
    }
}

