/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.qualitycontrol.cobol.rules;

import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.TextStatus;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.qualitycontrol.cobol.provider.PDPCodeReviewProvider;
import com.ibm.pdp.qualitycontrol.collector.PdpCobolData;
import com.ibm.rsar.analysis.codereview.cobol.CodeReviewResult;
import com.ibm.rsaz.analysis.core.element.AbstractAnalysisElement;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.result.AbstractAnalysisResult;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;

public class NoSegmentPhysicalAccessOverideRule
extends AbstractAnalysisRule {
    private int lastViolationLineRank = -1;
    private int lastViolationEndIndex = -1;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2016. All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void analyze(AnalysisHistory analysisHistory) {
        String historyId = analysisHistory.getHistoryId();
        PdpCobolData pdpCobolData = ((PDPCodeReviewProvider)this.getProvider()).getPdpCobolData(historyId);
        if (pdpCobolData != null) {
            Iterator rootNodes = pdpCobolData.getEditTree().rootNodes();
            while (rootNodes.hasNext()) {
                this.analyseOverwrittenGeneratedLines(historyId, pdpCobolData, (ITextNode)rootNodes.next());
            }
        }
    }

    private boolean isAllowedNodes(ITextNode textNode) {
        String tagname = textNode.enclosingTagName();
        if (tagname.startsWith("F80-")) {
            return this.isProcedureDivision(textNode);
        }
        return false;
    }

    private boolean isProcedureDivision(ITextNode node) {
        String tagname = node.enclosingTagName();
        if (tagname.equals("PROCEDURE")) {
            return true;
        }
        ITextNode parentNode = node.parentNode();
        if (parentNode == null) {
            return false;
        }
        return this.isProcedureDivision(parentNode);
    }

    private void analyseOverwrittenGeneratedLines(String historyId, PdpCobolData pdpCobolData, ITextNode node) {
        this.lastViolationLineRank = -1;
        this.lastViolationEndIndex = -1;
        if (this.isOverwrittedGeneratedLines(node) && this.isAllowedNodes(node)) {
            this.addResult(historyId, pdpCobolData, node);
        }
        if (node.includeUserSubNode()) {
            Iterator subnodes = node.sons();
            while (subnodes.hasNext()) {
                this.analyseOverwrittenGeneratedLines(historyId, pdpCobolData, (ITextNode)subnodes.next());
            }
        }
    }

    private boolean isOverwrittedGeneratedLines(ITextNode node) {
        TextStatus textStatus = node.getTextStatus();
        return this.isModifiedGeneratedLine(textStatus) && !this.isMacroStructure(node.enclosingGeneratedTag());
    }

    private boolean isSameLineViolation(int beginIdx, int lineRank) {
        return lineRank <= this.lastViolationLineRank || beginIdx < this.lastViolationEndIndex;
    }

    private void addResult(String historyId, PdpCobolData pdpCobolData, ITextNode node) {
        int beginIdx = node.beginIndex();
        int endIdx = node.endIndex();
        int lineRank = pdpCobolData.lineRankFromCharIndex(beginIdx);
        if (!this.isSameLineViolation(beginIdx, lineRank)) {
            IResource resource = pdpCobolData.getResource();
            this.lastViolationLineRank = lineRank;
            this.lastViolationEndIndex = endIdx;
            CodeReviewResult violation = new CodeReviewResult(resource.getFullPath().toString(), 1 + lineRank, beginIdx, endIdx - beginIdx, resource, (AbstractAnalysisRule)this, historyId, true);
            violation.setOwner((AbstractAnalysisElement)this);
            this.addHistoryResultSet(historyId, (AbstractAnalysisResult)violation);
        }
    }

    private boolean isModifiedGeneratedLine(TextStatus status) {
        switch (status) {
            case Deleted: {
                return true;
            }
            case Modified: {
                return true;
            }
        }
        return false;
    }

    private boolean isMacroStructure(IGeneratedTag generatedTag) {
        return generatedTag == null || generatedTag.getProperty("msp") != null;
    }
}

