/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.qualitycontrol.cobol.rules;

import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.TextStatus;
import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.qualitycontrol.cobol.provider.PDPCodeReviewProvider;
import com.ibm.pdp.qualitycontrol.collector.PdpCobolData;
import com.ibm.rsar.analysis.codereview.cobol.CodeReviewResult;
import com.ibm.rsaz.analysis.core.element.AbstractAnalysisElement;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.result.AbstractAnalysisResult;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;

public class NoMacroOverrideRule
extends AbstractAnalysisRule {
    protected int lastViolationLineRank;
    protected int lastViolationEndIndex;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016. All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void analyze(AnalysisHistory history) {
        String historyId = history.getHistoryId();
        PdpCobolData pdpCobolData = ((PDPCodeReviewProvider)this.getProvider()).getPdpCobolData(historyId);
        if (pdpCobolData != null) {
            this.findOverwrittenMacroLines(historyId, pdpCobolData);
        }
    }

    protected void findOverwrittenMacroLines(String historyId, PdpCobolData pdpCobolData) {
        this.lastViolationLineRank = -1;
        this.lastViolationEndIndex = -1;
        IEditTree editTree = pdpCobolData.getEditTree();
        Iterator rootNodes = editTree.rootNodes();
        while (rootNodes.hasNext()) {
            this.findOverwrittenMacroLinesInto(historyId, pdpCobolData, (ITextNode)rootNodes.next());
        }
    }

    protected void findOverwrittenMacroLinesInto(String historyId, PdpCobolData pdpCobolData, ITextNode node) {
        IGeneratedTag tag;
        TextStatus status = node.getTextStatus();
        if ((status == TextStatus.Deleted || status == TextStatus.Modified) && (tag = node.enclosingGeneratedTag()) != null && tag.getProperty("msp") != null) {
            int beginIdx = node.beginIndex();
            int lineRank = pdpCobolData.lineRankFromCharIndex(beginIdx);
            this.addResult(pdpCobolData.getResource(), historyId, beginIdx, node.endIndex(), lineRank);
        }
        if (!node.includeUserSubNode()) {
            return;
        }
        Iterator subnodes = node.sons();
        while (subnodes.hasNext()) {
            this.findOverwrittenMacroLinesInto(historyId, pdpCobolData, (ITextNode)subnodes.next());
        }
    }

    public void addResult(IResource resource, String historyId, int beginIdx, int endIdx, int lineRank) {
        if (lineRank <= this.lastViolationLineRank || beginIdx < this.lastViolationEndIndex) {
            return;
        }
        this.lastViolationLineRank = lineRank;
        this.lastViolationEndIndex = endIdx;
        CodeReviewResult violation = new CodeReviewResult(resource.getFullPath().toString(), 1 + lineRank, beginIdx, endIdx - beginIdx, resource, (AbstractAnalysisRule)this, historyId, true);
        violation.setOwner((AbstractAnalysisElement)this);
        this.addHistoryResultSet(historyId, (AbstractAnalysisResult)violation);
    }
}

