/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.qualitycontrol.cobol.rules;

import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.TextStatus;
import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.qualitycontrol.cobol.provider.PDPCodeReviewProvider;
import com.ibm.pdp.qualitycontrol.collector.PdpCobolData;
import com.ibm.rsar.analysis.codereview.cobol.CodeReviewResult;
import com.ibm.rsaz.analysis.core.element.AbstractAnalysisElement;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.result.AbstractAnalysisResult;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;

public class NoBeginLineRule
extends AbstractAnalysisRule {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected int lastViolationLineRank;
    protected int lastViolationEndIndex;
    private static final String identificationDivision = "IDENTIFICATION";
    private static final String environmentDivision = "ENVIRONMENT";
    private static final String dataDivision = "DATA";

    public void analyze(AnalysisHistory history) {
        String historyId = history.getHistoryId();
        PdpCobolData pdpCobolData = ((PDPCodeReviewProvider)this.getProvider()).getPdpCobolData(historyId);
        if (pdpCobolData != null) {
            this.findSpecificLines(historyId, pdpCobolData);
        }
    }

    private void findSpecificLinesInto(String historyId, PdpCobolData pdpCobolData, ITextNode node) {
        IGeneratedTag tag;
        TextStatus status = node.getTextStatus();
        if ((status == TextStatus.Deleted || status == TextStatus.Modified || status == TextStatus.Inserted) && (tag = node.enclosingGeneratedTag()) != null) {
            int beginIdx = node.beginIndex();
            int lineRank = pdpCobolData.lineRankFromCharIndex(beginIdx);
            this.addResult(pdpCobolData.getResource(), historyId, beginIdx, node.endIndex(), lineRank);
        }
        if (node.includeUserSubNode()) {
            Iterator subnodes = node.sons();
            while (subnodes.hasNext()) {
                this.findSpecificLinesInto(historyId, pdpCobolData, (ITextNode)subnodes.next());
            }
        }
    }

    public void addResult(IResource resource, String historyId, int beginIdx, int endIdx, int lineRank) {
        if (lineRank <= this.lastViolationLineRank || beginIdx < this.lastViolationEndIndex) {
            return;
        }
        this.lastViolationLineRank = lineRank;
        this.lastViolationEndIndex = endIdx;
        CodeReviewResult violation = new CodeReviewResult(resource.getFullPath().toString(), 1 + lineRank, beginIdx, endIdx - beginIdx, resource, (AbstractAnalysisRule)this, historyId, true);
        violation.setOwner((AbstractAnalysisElement)this);
        this.addHistoryResultSet(historyId, (AbstractAnalysisResult)violation);
    }

    protected ITextNode findSection(IEditTree editTree, String sectionName) {
        return editTree.nodeFromTagName(sectionName);
    }

    private void findSpecificLines(String historyId, PdpCobolData pdpCobolData) {
        this.lastViolationLineRank = -1;
        this.lastViolationEndIndex = -1;
        this.findSpecificLinesInSection(historyId, pdpCobolData, identificationDivision);
        this.findSpecificLinesInSection(historyId, pdpCobolData, environmentDivision);
    }

    private void findSpecificLinesInSection(String historyId, PdpCobolData pdpCobolData, String sectionName) {
        Iterator rootNodes = pdpCobolData.getEditTree().rootNodes();
        boolean foundDataDiv = false;
        while (rootNodes.hasNext()) {
            ITextNode rootNode = (ITextNode)rootNodes.next();
            if (!rootNode.sons().hasNext() && rootNode.includeChangedText()) {
                TextStatus status = rootNode.getTextStatus();
                if (status != TextStatus.Deleted && status != TextStatus.Modified && status != TextStatus.Inserted) continue;
                int beginIdx = rootNode.beginIndex();
                int lineRank = pdpCobolData.lineRankFromCharIndex(beginIdx);
                this.addResult(pdpCobolData.getResource(), historyId, beginIdx, rootNode.endIndex(), lineRank);
                continue;
            }
            Iterator sons = rootNode.sons();
            while (sons.hasNext()) {
                TextStatus status;
                ITextNode node = (ITextNode)sons.next();
                if (dataDivision.equals(node.getLabel())) {
                    foundDataDiv = true;
                    break;
                }
                if (node.includeChangedText() && ((status = node.getTextStatus()) == TextStatus.Deleted || status == TextStatus.Modified || status == TextStatus.Inserted)) {
                    int beginIdx = node.beginIndex();
                    int lineRank = pdpCobolData.lineRankFromCharIndex(beginIdx);
                    this.addResult(pdpCobolData.getResource(), historyId, beginIdx, node.endIndex(), lineRank);
                }
                if (!node.includeUserSubNode()) continue;
                Iterator subnodes = node.sons();
                while (subnodes.hasNext()) {
                    this.findSpecificLinesInto(historyId, pdpCobolData, (ITextNode)subnodes.next());
                }
            }
            if (foundDataDiv) break;
        }
    }
}

