/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.qualitycontrol.cobol.rules;

import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.pacbase.PacTool;
import com.ibm.pdp.qualitycontrol.cobol.provider.AbstractRppCobolRule;
import com.ibm.pdp.qualitycontrol.cobol.provider.PDPCodeReviewProvider;
import com.ibm.pdp.qualitycontrol.collector.PdpCobolData;
import com.ibm.systemz.cobol.editor.core.parser.Ast.ASTNode;
import com.ibm.systemz.cobol.editor.core.parser.Ast.IGoToStatement;
import java.util.Iterator;
import java.util.List;
import lpg.runtime.IAst;

public class GotoParagraphRule
extends AbstractRppCobolRule {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public List<IAst> performRule(ASTNode baseNode) {
        com.ibm.rsar.analysis.codereview.cobol.rules.GotoParagraphRule rule = new com.ibm.rsar.analysis.codereview.cobol.rules.GotoParagraphRule();
        List<IAst> asts = rule.performRule(baseNode);
        PdpCobolData pdpCobolData = ((PDPCodeReviewProvider)this.getProvider()).getPdpCobolData(this.getHistoryId());
        if (pdpCobolData == null) {
            return asts;
        }
        this.filterResults(asts);
        asts = this.removeNotAllowedGoto(asts, pdpCobolData.getEditTree());
        return asts;
    }

    private List<IAst> removeNotAllowedGoto(List<IAst> asts, IEditTree editTree) {
        Iterator<IAst> iterator = asts.iterator();
        while (iterator.hasNext()) {
            IAst node = iterator.next();
            int beginIdx = node.getLeftIToken().getStartOffset();
            int endIdx = node.getRightIToken().getEndOffset();
            ITextNode textNode = editTree.includingNode(beginIdx, endIdx);
            String etiqu = null;
            if (node instanceof IGoToStatement) {
                int begGoto = ((IGoToStatement)node).getRightIToken().getStartOffset();
                etiqu = editTree.getTextProcessor().getText().subSequence(begGoto, endIdx + 1).toString();
            }
            if (!this.checkAllowedNodes(textNode, beginIdx, etiqu)) continue;
            iterator.remove();
        }
        return asts;
    }

    /*
     * Unable to fully structure code
     */
    private boolean checkAllowedNodes(ITextNode textNode, int beginIdx, String etiqu) {
        block4: {
            newLine = PdpTool.determineDelimiterOfV2((CharSequence)textNode.text());
            nlLength = newLine.length();
            indexBeg = PacTool.searchFirstSCHorSCBforCOA((String)newLine, (String)textNode.text().toString(), (int)0);
            fi = PacTool.getFunctionInformations((String)textNode.getLabel().toString(), (ITextNode)textNode, (boolean)true);
            if (fi == null) {
                return false;
            }
            if (textNode.beginIndex() + fi.getBodyEndIdx() <= beginIdx) break block4;
            if (textNode.beginIndex() + fi.getBodyBeginIdx() <= beginIdx) ** GOTO lbl27
            return true;
lbl-1000:
            // 1 sources

            {
                indexEnd = textNode.text().toString().indexOf(newLine, indexBeg + nlLength);
                found = false;
                tmpLine = null;
                do {
                    indexBeg = textNode.text().toString().indexOf(newLine, indexEnd);
                    indexEnd = textNode.text().toString().indexOf(newLine, indexBeg + nlLength);
                    tmpLine = textNode.text().toString().subSequence(indexBeg += nlLength, indexEnd).toString();
                    if (!tmpLine.startsWith("       ")) continue;
                    v0 = found = tmpLine.charAt(7) == 'F' && tmpLine.charAt(12) == '-';
                } while (!found && tmpLine.charAt(7) != 'F');
                line = new StringBuilder(textNode.text().toString().subSequence(indexBeg, indexEnd));
                etiquette = line.subSequence(7, indexPoint = line.indexOf(".")).toString();
                if (etiquette.equals(etiqu)) {
                    return true;
                }
                line.append(newLine);
                indexBeg = PacTool.searchFirstSCHorSCBforCOA((String)newLine, (String)textNode.text().toString(), (int)(indexEnd += nlLength));
lbl27:
                // 2 sources

                ** while (indexBeg != -1)
            }
lbl28:
            // 1 sources

            return false;
        }
        return true;
    }
}

