/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.qualitycontrol.cobol.rules;

import com.ibm.pdp.qualitycontrol.cobol.provider.PDPCodeReviewProvider;
import com.ibm.rsar.analysis.codereview.cobol.CodeReviewResult;
import com.ibm.rsaz.analysis.core.element.AbstractAnalysisElement;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.result.AbstractAnalysisResult;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;

public class AnalyzeCobolSyntaxError
extends AbstractAnalysisRule {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void analyze(AnalysisHistory analysisHistory) {
        PDPCodeReviewProvider reviewProvider = (PDPCodeReviewProvider)this.getProvider();
        if (reviewProvider.getSyntaxErrors() == null || reviewProvider.getSyntaxErrors().isEmpty()) {
            return;
        }
        String historyId = analysisHistory.getHistoryId();
        for (IResource resource : reviewProvider.getSyntaxErrors().keySet()) {
            List<LineInfo> linesInfo = null;
            try {
                linesInfo = this.readLines(resource);
            }
            catch (Exception exception) {
                return;
            }
            List errors = (List)reviewProvider.getSyntaxErrors().get(resource);
            int idx = -1;
            for (String error : errors) {
                idx = error.indexOf(58);
                if (idx <= 0) continue;
                try {
                    int line = Integer.parseInt(error.substring(0, idx));
                    if (line > linesInfo.size() + 1) continue;
                    CodeReviewResult violation = new CodeReviewResult(resource.getFullPath().toString(), line, linesInfo.get((int)(line - 2)).start, linesInfo.get((int)(line - 1)).length, resource, (AbstractAnalysisRule)this, historyId, true);
                    violation.setOwner((AbstractAnalysisElement)this);
                    this.addHistoryResultSet(historyId, (AbstractAnalysisResult)violation);
                }
                catch (Exception exception) {}
            }
        }
    }

    private List<LineInfo> readLines(IResource resource) throws IOException {
        int newLineLength = System.getProperty("line.separator").length();
        ArrayList<LineInfo> linesInfo = new ArrayList<LineInfo>();
        try (BufferedReader br = new BufferedReader(new FileReader(resource.getLocation().toOSString()));){
            String line = br.readLine();
            if (line == null) {
                ArrayList<LineInfo> arrayList = linesInfo;
                return arrayList;
            }
            int start = 0;
            linesInfo.add(new LineInfo(start, line.length()));
            start += line.length() + newLineLength;
            while (line != null) {
                line = br.readLine();
                if (line == null) continue;
                linesInfo.add(new LineInfo(start += line.length() + newLineLength, line.length()));
            }
        }
        return linesInfo;
    }

    private static class LineInfo {
        int start;
        int length;

        public LineInfo(int start, int length) {
            this.start = start;
            this.length = length;
        }
    }
}

