/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.qualitycontrol.cobol.provider;

import com.ibm.pdp.qualitycontrol.cobol.provider.AbstractRppCobolRule;
import com.ibm.rsaz.analysis.core.logging.Log;
import com.ibm.rsaz.analysis.core.result.AbstractAnalysisResult;
import com.ibm.rsaz.analysis.core.result.BasicCodeReviewResult;
import com.ibm.rsaz.analysis.core.ui.internal.actions.ShowAnalysisAnnotationsDelegate;
import com.ibm.rsaz.analysis.core.viewer.IAnalysisViewer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public class PDPCodeReviewViewer
implements IAnalysisViewer {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void showView(AbstractAnalysisResult result) {
        if (result instanceof AbstractRppCobolRule.CodeReviewResultWithCustomLabel) {
            final AbstractRppCobolRule.CodeReviewResultWithCustomLabel specificResult = (AbstractRppCobolRule.CodeReviewResultWithCustomLabel)result;
            Job job = new Job(""){

                protected IStatus run(IProgressMonitor monitor) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Path path = new Path(specificResult.getResourceName().substring(0, specificResult.getResourceName().indexOf(" ")));
                            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                            if (file != null && file.exists()) {
                                try {
                                    ShowAnalysisAnnotationsDelegate.showAnalysisAnnotations((boolean)true);
                                    ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file, (boolean)true);
                                    if (editor.isDirty()) {
                                        editor.doSave(null);
                                    }
                                    editor.selectAndReveal(specificResult.getStart(), specificResult.getLengthSelection());
                                }
                                catch (PartInitException e) {
                                    Log.severe((String)"", (Throwable)e);
                                }
                            }
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        } else {
            final BasicCodeReviewResult specificResult = (BasicCodeReviewResult)result;
            Job job = new Job(""){

                protected IStatus run(IProgressMonitor monitor) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Path path = new Path(specificResult.getResourceName());
                            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                            if (file != null && file.exists()) {
                                try {
                                    ShowAnalysisAnnotationsDelegate.showAnalysisAnnotations((boolean)true);
                                    ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file, (boolean)true);
                                    if (editor.isDirty()) {
                                        editor.doSave(null);
                                    }
                                    editor.selectAndReveal(specificResult.getStart(), specificResult.getLengthSelection());
                                }
                                catch (PartInitException e) {
                                    Log.severe((String)"", (Throwable)e);
                                }
                            }
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }
}

