/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.qualitycontrol.cobol.provider;

import com.ibm.pdp.framework.ControllerFactory;
import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.framework.interfaces.IControllerFactory;
import com.ibm.pdp.qualitycontrol.collector.PdpCobolData;
import com.ibm.rsar.analysis.codereview.baseline.BaselineResultFilter;
import com.ibm.rsar.analysis.codereview.baseline.language.AbstractReviewResource;
import com.ibm.rsar.analysis.codereview.cobol.CodeReviewProvider;
import com.ibm.rsaz.analysis.core.category.DefaultAnalysisCategory;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;

public class PDPCodeReviewProvider
extends CodeReviewProvider {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015, 2024.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String RESOURCE_PROPERTY = "rpp.codereview.cobol.resource";
    private static final String ANALYZE_ERROR = "rpp.codereview.cobol.category.error.analyze";
    private List<IResource> analyseErrors = new ArrayList<IResource>();
    private Map<IResource, List<String>> syntaxErrors = new HashMap<IResource, List<String>>();
    boolean isInPostAnalyze = false;

    public void preAnalyze(AnalysisHistory history) {
        this.analyseErrors.clear();
        this.syntaxErrors.clear();
        super.preAnalyze(history);
        this.isInPostAnalyze = false;
    }

    protected AbstractReviewResource createCodeReviewResource(IResource resource, IDocument document, BaselineResultFilter filter, IProgressMonitor monitor, boolean documentIsPreviousVersion) {
        AbstractReviewResource abstractReviewResource = super.createCodeReviewResource(resource, document, filter, monitor, documentIsPreviousVersion);
        abstractReviewResource.getCompilationUnit();
        if (abstractReviewResource.getParseErrors() != null && !abstractReviewResource.getParseErrors().isEmpty()) {
            if (abstractReviewResource.getCompilationUnit() == null) {
                this.analyseErrors.add(resource);
            } else {
                this.syntaxErrors.put(resource, abstractReviewResource.getParseErrors());
            }
        }
        abstractReviewResource.unloadCompilationUnit();
        return abstractReviewResource;
    }

    public void postAnalyze(AnalysisHistory history) {
        this.isInPostAnalyze = true;
        this.rppPostAnalyze(history);
        this.analyseErrors.clear();
        this.syntaxErrors.clear();
        this.isInPostAnalyze = false;
        this.removeProperty(history.getHistoryId(), this.getPdpCobolDataId());
        this.removeProperty(history.getHistoryId(), "PDP_COBOL_DATA");
        super.postAnalyze(history);
    }

    public void rppPostAnalyze(AnalysisHistory history) {
        Collection selectedCategories = this.getSelectedCategories(history);
        if (!(this.analyseErrors.isEmpty() && this.syntaxErrors.isEmpty() || selectedCategories == null)) {
            for (DefaultAnalysisCategory category : selectedCategories) {
                if (!ANALYZE_ERROR.equals(category.getId())) continue;
                category.analyze(history);
                break;
            }
        }
    }

    public final List<IResource> getAnalyzeErrors() {
        if (!this.isInPostAnalyze) {
            return null;
        }
        return this.analyseErrors;
    }

    public final Map<IResource, List<String>> getSyntaxErrors() {
        if (!this.isInPostAnalyze) {
            return null;
        }
        return this.syntaxErrors;
    }

    protected String getResourcePropertyId() {
        return RESOURCE_PROPERTY;
    }

    protected void addExtensionPointProperties(AnalysisHistory history, IResource resource) {
        super.addExtensionPointProperties(history, resource);
        PdpCobolData pdpCobolData = this.getPdpCobolData(resource);
        this.setProperty(history.getHistoryId(), this.getPdpCobolDataId(), pdpCobolData);
        this.setProperty(history.getHistoryId(), "PDP_COBOL_DATA", pdpCobolData);
    }

    protected void removeExtensionPointProperties(AnalysisHistory history) {
        this.removeProperty(history.getHistoryId(), this.getPdpCobolDataId());
        this.removeProperty(history.getHistoryId(), "PDP_COBOL_DATA");
        this.removeProperty(history.getHistoryId(), RESOURCE_PROPERTY);
    }

    private synchronized PdpCobolData getPdpCobolData(IResource resource) {
        IControllerFactory factory = ControllerFactory.getInstance();
        if (factory == null) {
            return null;
        }
        String resourcePathName = resource.getFullPath().toString();
        IController controler = factory.getController(resourcePathName);
        if (controler == null) {
            IPath resourcePath = resource.getLocation();
            IPath wksPath = resource.getWorkspace().getRoot().getLocation();
            resourcePath = resourcePath.removeFirstSegments(wksPath.segmentCount());
            if ((resource = resource.getWorkspace().getRoot().findMember(resourcePath)) == null || resource.getFullPath() == null) {
                return null;
            }
            resourcePathName = resource.getFullPath().toString();
            controler = factory.getController(resourcePathName);
            if (controler == null) {
                return null;
            }
        }
        return new PdpCobolData(resource, controler);
    }

    private String getPdpCobolDataId() {
        return ((Object)((Object)this)).getClass().getName() + "_PDP_COBOL_DATA";
    }

    public PdpCobolData getPdpCobolData(String historyId) {
        return (PdpCobolData)this.getProperty(historyId, this.getPdpCobolDataId());
    }
}

