/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.qualitycontrol.cobol.provider;

import com.ibm.pdp.qualitycontrol.cobol.provider.AbstractRppCobolRule;
import com.ibm.pdp.qualitycontrol.cobol.provider.PDPCodeReviewProvider;
import com.ibm.pdp.qualitycontrol.collector.PdpCobolData;
import com.ibm.rsar.analysis.codereview.cobol.CodeReviewResource;
import com.ibm.rsar.analysis.codereview.cobol.CodeReviewResult;
import com.ibm.rsar.analysis.codereview.cobol.rules.NameCollector;
import com.ibm.rsaz.analysis.core.element.AbstractAnalysisElement;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.result.AbstractAnalysisResult;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import com.ibm.systemz.cobol.editor.core.parser.Ast.ASTNode;
import java.util.List;
import lpg.runtime.IAst;
import org.eclipse.core.resources.IResource;

public abstract class AbstractRppCobolRuleWithoutDeviation
extends AbstractRppCobolRule {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected int beginingLineNumber = -1;
    protected int endingLineNumber = -1;
    protected int beginingIndexPosition = -1;
    protected int endingIndexPosition = -1;

    @Override
    public void analyze(AnalysisHistory history) {
        CodeReviewResource rdzData;
        this.beginingLineNumber = -1;
        this.beginingIndexPosition = -1;
        this.endingIndexPosition = -1;
        this.historyId = history.getHistoryId();
        this.resource = rdzData = (CodeReviewResource)this.getProvider().getProperty(this.historyId, "rpp.codereview.cobol.resource");
        this.fileName = (String)this.getProvider().getProperty(this.historyId, NameCollector.KEYS[0]);
        PdpCobolData pdpCobolData = ((PDPCodeReviewProvider)this.getProvider()).getPdpCobolData(this.historyId);
        if (rdzData == null) {
            return;
        }
        ASTNode node = (ASTNode)rdzData.getCompilationUnit();
        if (node == null) {
            return;
        }
        List<IAst> results = this.performRule(node);
        if (results == null || results.isEmpty()) {
            return;
        }
        if (this.isResultFiltered()) {
            this.filterResults(results);
        }
        if (results.isEmpty()) {
            return;
        }
        this.addResult(pdpCobolData.getResource(), this.historyId, results);
    }

    protected void addResult(IResource resource, String historyId, List<IAst> results) {
        int i = 0;
        while (i < results.size()) {
            IAst node = results.get(i);
            this.beginingLineNumber = node.getLeftIToken().getLine();
            this.beginingIndexPosition = node.getLeftIToken().getStartOffset();
            this.endingIndexPosition = node.getRightIToken().getEndOffset();
            Object result = null;
            String extraLabel = this.getExtraLabel();
            result = extraLabel == null || extraLabel.length() == 0 ? new CodeReviewResult(resource.getFullPath().toString(), this.beginingLineNumber, this.beginingIndexPosition, this.endingIndexPosition - this.beginingIndexPosition, resource, (AbstractAnalysisRule)this, historyId, true) : new AbstractRppCobolRule.CodeReviewResultWithCustomLabel(extraLabel, resource.getFullPath().toString(), this.beginingLineNumber, this.beginingIndexPosition, this.endingIndexPosition - this.beginingIndexPosition, resource, this, historyId);
            result.setOwner((AbstractAnalysisElement)this);
            this.addHistoryResultSet(historyId, (AbstractAnalysisResult)result);
            ++i;
        }
    }

    public void addResult(IResource resource, String historyId) {
        Object result = null;
        String extraLabel = this.getExtraLabel();
        result = extraLabel == null || extraLabel.length() == 0 ? new CodeReviewResult(resource.getFullPath().toString(), this.beginingLineNumber, this.beginingIndexPosition, this.endingIndexPosition - this.beginingIndexPosition, resource, (AbstractAnalysisRule)this, historyId, true) : new AbstractRppCobolRule.CodeReviewResultWithCustomLabel(extraLabel, resource.getFullPath().toString(), this.beginingLineNumber, this.beginingIndexPosition, this.endingIndexPosition - this.beginingIndexPosition, resource, this, historyId);
        result.setOwner((AbstractAnalysisElement)this);
        this.addHistoryResultSet(historyId, (AbstractAnalysisResult)result);
    }

    @Override
    public String getExtraLabel() {
        return "";
    }
}

